/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.value;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.client.value.LDValueType;
import com.launchdarkly.client.value.LDValueTypeAdapter;
import java.io.IOException;

@JsonAdapter(value=LDValueTypeAdapter.class)
final class LDValueBool
extends LDValue {
    private static final LDValueBool TRUE = new LDValueBool(true);
    private static final LDValueBool FALSE = new LDValueBool(false);
    private static final JsonElement JSON_TRUE = new JsonPrimitive(Boolean.valueOf(true));
    private static final JsonElement JSON_FALSE = new JsonPrimitive(Boolean.valueOf(false));
    private final boolean value;

    static LDValueBool fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    private LDValueBool(boolean value) {
        this.value = value;
    }

    @Override
    public LDValueType getType() {
        return LDValueType.BOOLEAN;
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public String toJsonString() {
        return this.value ? "true" : "false";
    }

    @Override
    void write(JsonWriter writer) throws IOException {
        writer.value(this.value);
    }

    @Override
    JsonElement computeJsonElement() {
        return this.value ? JSON_TRUE : JSON_FALSE;
    }
}

