/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.value;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.client.value.LDValueType;
import com.launchdarkly.client.value.LDValueTypeAdapter;
import com.launchdarkly.shaded.com.google.common.base.Function;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;

@JsonAdapter(value=LDValueTypeAdapter.class)
final class LDValueJsonElement
extends LDValue {
    private final JsonElement value;
    private final LDValueType type;

    static LDValueJsonElement copyValue(JsonElement value) {
        return new LDValueJsonElement(LDValueJsonElement.deepCopy(value));
    }

    static LDValueJsonElement wrapUnsafeValue(JsonElement value) {
        return new LDValueJsonElement(value);
    }

    LDValueJsonElement(JsonElement value) {
        this.value = value;
        this.type = LDValueJsonElement.typeFromValue(value);
    }

    private static LDValueType typeFromValue(JsonElement value) {
        if (value != null) {
            if (value.isJsonPrimitive()) {
                JsonPrimitive p = value.getAsJsonPrimitive();
                if (p.isBoolean()) {
                    return LDValueType.BOOLEAN;
                }
                if (p.isNumber()) {
                    return LDValueType.NUMBER;
                }
                if (p.isString()) {
                    return LDValueType.STRING;
                }
                return LDValueType.NULL;
            }
            if (value.isJsonArray()) {
                return LDValueType.ARRAY;
            }
            if (value.isJsonObject()) {
                return LDValueType.OBJECT;
            }
        }
        return LDValueType.NULL;
    }

    @Override
    public LDValueType getType() {
        return this.type;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean booleanValue() {
        return this.type == LDValueType.BOOLEAN && this.value.getAsBoolean();
    }

    @Override
    public boolean isNumber() {
        return this.type == LDValueType.NUMBER;
    }

    @Override
    public boolean isInt() {
        return this.type == LDValueType.NUMBER && LDValueJsonElement.isInteger(this.value.getAsFloat());
    }

    @Override
    public int intValue() {
        return this.type == LDValueType.NUMBER ? (int)this.value.getAsFloat() : 0;
    }

    @Override
    public long longValue() {
        return this.type == LDValueType.NUMBER ? (long)this.value.getAsDouble() : 0L;
    }

    @Override
    public float floatValue() {
        return this.type == LDValueType.NUMBER ? this.value.getAsFloat() : 0.0f;
    }

    @Override
    public double doubleValue() {
        return this.type == LDValueType.NUMBER ? this.value.getAsDouble() : 0.0;
    }

    @Override
    public boolean isString() {
        return this.type == LDValueType.STRING;
    }

    @Override
    public String stringValue() {
        return this.type == LDValueType.STRING ? this.value.getAsString() : null;
    }

    @Override
    public int size() {
        switch (this.type) {
            case ARRAY: {
                return this.value.getAsJsonArray().size();
            }
            case OBJECT: {
                return this.value.getAsJsonObject().size();
            }
        }
        return 0;
    }

    @Override
    public Iterable<String> keys() {
        if (this.type == LDValueType.OBJECT) {
            return Iterables.transform(this.value.getAsJsonObject().entrySet(), new Function<Map.Entry<String, JsonElement>, String>(){

                @Override
                public String apply(Map.Entry<String, JsonElement> e) {
                    return e.getKey();
                }
            });
        }
        return ImmutableList.of();
    }

    @Override
    public Iterable<LDValue> values() {
        switch (this.type) {
            case ARRAY: {
                return Iterables.transform(this.value.getAsJsonArray(), new Function<JsonElement, LDValue>(){

                    @Override
                    public LDValue apply(JsonElement e) {
                        return LDValue.unsafeFromJsonElement(e);
                    }
                });
            }
            case OBJECT: {
                return Iterables.transform(this.value.getAsJsonObject().entrySet(), new Function<Map.Entry<String, JsonElement>, LDValue>(){

                    @Override
                    public LDValue apply(Map.Entry<String, JsonElement> e) {
                        return LDValue.unsafeFromJsonElement(e.getValue());
                    }
                });
            }
        }
        return ImmutableList.of();
    }

    @Override
    public LDValue get(int index) {
        if (this.type == LDValueType.ARRAY) {
            JsonArray a = this.value.getAsJsonArray();
            if (index >= 0 && index < a.size()) {
                return LDValueJsonElement.unsafeFromJsonElement(a.get(index));
            }
        }
        return LDValueJsonElement.ofNull();
    }

    @Override
    public LDValue get(String name) {
        if (this.type == LDValueType.OBJECT) {
            return LDValueJsonElement.unsafeFromJsonElement(this.value.getAsJsonObject().get(name));
        }
        return LDValueJsonElement.ofNull();
    }

    @Override
    void write(JsonWriter writer) throws IOException {
        gson.toJson(this.value, writer);
    }

    @Override
    JsonElement computeJsonElement() {
        return this.value;
    }

    static JsonElement deepCopy(JsonElement value) {
        if (value != null && !value.isJsonPrimitive()) {
            if (value.isJsonArray()) {
                JsonArray a = value.getAsJsonArray();
                JsonArray ret = new JsonArray();
                for (JsonElement e : a) {
                    ret.add(LDValueJsonElement.deepCopy(e));
                }
                return ret;
            }
            if (value.isJsonObject()) {
                JsonObject o = value.getAsJsonObject();
                JsonObject ret = new JsonObject();
                for (Map.Entry e : o.entrySet()) {
                    ret.add((String)e.getKey(), LDValueJsonElement.deepCopy((JsonElement)e.getValue()));
                }
                return ret;
            }
        }
        return value;
    }
}

