/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import java.util.Objects;

public abstract class EvaluationReason {
    private static final Error ERROR_CLIENT_NOT_READY = new Error(ErrorKind.CLIENT_NOT_READY, null);
    private static final Error ERROR_FLAG_NOT_FOUND = new Error(ErrorKind.FLAG_NOT_FOUND, null);
    private static final Error ERROR_MALFORMED_FLAG = new Error(ErrorKind.MALFORMED_FLAG, null);
    private static final Error ERROR_USER_NOT_SPECIFIED = new Error(ErrorKind.USER_NOT_SPECIFIED, null);
    private static final Error ERROR_WRONG_TYPE = new Error(ErrorKind.WRONG_TYPE, null);
    private static final Error ERROR_EXCEPTION = new Error(ErrorKind.EXCEPTION, null);
    private final Kind kind;

    public Kind getKind() {
        return this.kind;
    }

    public int getRuleIndex() {
        return -1;
    }

    public String getRuleId() {
        return null;
    }

    public String getPrerequisiteKey() {
        return null;
    }

    public ErrorKind getErrorKind() {
        return null;
    }

    public Exception getException() {
        return null;
    }

    public String toString() {
        return this.getKind().name();
    }

    protected EvaluationReason(Kind kind) {
        this.kind = kind;
    }

    public static Off off() {
        return Off.instance;
    }

    public static TargetMatch targetMatch() {
        return TargetMatch.instance;
    }

    public static RuleMatch ruleMatch(int ruleIndex, String ruleId) {
        return new RuleMatch(ruleIndex, ruleId);
    }

    public static PrerequisiteFailed prerequisiteFailed(String prerequisiteKey) {
        return new PrerequisiteFailed(prerequisiteKey);
    }

    public static Fallthrough fallthrough() {
        return Fallthrough.instance;
    }

    public static Error error(ErrorKind errorKind) {
        switch (errorKind) {
            case CLIENT_NOT_READY: {
                return ERROR_CLIENT_NOT_READY;
            }
            case EXCEPTION: {
                return ERROR_EXCEPTION;
            }
            case FLAG_NOT_FOUND: {
                return ERROR_FLAG_NOT_FOUND;
            }
            case MALFORMED_FLAG: {
                return ERROR_MALFORMED_FLAG;
            }
            case USER_NOT_SPECIFIED: {
                return ERROR_USER_NOT_SPECIFIED;
            }
            case WRONG_TYPE: {
                return ERROR_WRONG_TYPE;
            }
        }
        return new Error(errorKind, null);
    }

    public static Error exception(Exception exception) {
        return new Error(ErrorKind.EXCEPTION, exception);
    }

    @Deprecated
    public static class Error
    extends EvaluationReason {
        private final ErrorKind errorKind;
        private final transient Exception exception;

        private Error(ErrorKind errorKind, Exception exception) {
            super(Kind.ERROR);
            Preconditions.checkNotNull(errorKind);
            this.errorKind = errorKind;
            this.exception = exception;
        }

        @Override
        public ErrorKind getErrorKind() {
            return this.errorKind;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        public boolean equals(Object other) {
            return other instanceof Error && this.errorKind == ((Error)other).errorKind && Objects.equals(this.exception, ((Error)other).exception);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.errorKind, this.exception});
        }

        @Override
        public String toString() {
            return this.getKind().name() + "(" + this.errorKind.name() + (this.exception == null ? "" : "," + this.exception) + ")";
        }
    }

    @Deprecated
    public static class Fallthrough
    extends EvaluationReason {
        private static final Fallthrough instance = new Fallthrough();

        private Fallthrough() {
            super(Kind.FALLTHROUGH);
        }
    }

    @Deprecated
    public static class PrerequisiteFailed
    extends EvaluationReason {
        private final String prerequisiteKey;

        private PrerequisiteFailed(String prerequisiteKey) {
            super(Kind.PREREQUISITE_FAILED);
            this.prerequisiteKey = Preconditions.checkNotNull(prerequisiteKey);
        }

        @Override
        public String getPrerequisiteKey() {
            return this.prerequisiteKey;
        }

        public boolean equals(Object other) {
            return other instanceof PrerequisiteFailed && ((PrerequisiteFailed)other).prerequisiteKey.equals(this.prerequisiteKey);
        }

        public int hashCode() {
            return this.prerequisiteKey.hashCode();
        }

        @Override
        public String toString() {
            return this.getKind().name() + "(" + this.prerequisiteKey + ")";
        }
    }

    @Deprecated
    public static class RuleMatch
    extends EvaluationReason {
        private final int ruleIndex;
        private final String ruleId;

        private RuleMatch(int ruleIndex, String ruleId) {
            super(Kind.RULE_MATCH);
            this.ruleIndex = ruleIndex;
            this.ruleId = ruleId;
        }

        @Override
        public int getRuleIndex() {
            return this.ruleIndex;
        }

        @Override
        public String getRuleId() {
            return this.ruleId;
        }

        public boolean equals(Object other) {
            if (other instanceof RuleMatch) {
                RuleMatch o = (RuleMatch)other;
                return this.ruleIndex == o.ruleIndex && Objects.equals(this.ruleId, o.ruleId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.ruleIndex, this.ruleId);
        }

        @Override
        public String toString() {
            return this.getKind().name() + "(" + this.ruleIndex + (this.ruleId == null ? "" : "," + this.ruleId) + ")";
        }
    }

    @Deprecated
    public static class TargetMatch
    extends EvaluationReason {
        private static final TargetMatch instance = new TargetMatch();

        private TargetMatch() {
            super(Kind.TARGET_MATCH);
        }
    }

    @Deprecated
    public static class Off
    extends EvaluationReason {
        private static final Off instance = new Off();

        private Off() {
            super(Kind.OFF);
        }
    }

    public static enum ErrorKind {
        CLIENT_NOT_READY,
        FLAG_NOT_FOUND,
        MALFORMED_FLAG,
        USER_NOT_SPECIFIED,
        WRONG_TYPE,
        EXCEPTION;

    }

    public static enum Kind {
        OFF,
        FALLTHROUGH,
        TARGET_MATCH,
        RULE_MATCH,
        PREREQUISITE_FAILED,
        ERROR;

    }
}

