/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.client.interfaces.DiagnosticDescription;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryFeatureStore
implements FeatureStore,
DiagnosticDescription {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryFeatureStore.class);
    private volatile ImmutableMap<VersionedDataKind<?>, Map<String, VersionedData>> allData = ImmutableMap.of();
    private volatile boolean initialized = false;
    private Object writeLock = new Object();

    @Override
    public <T extends VersionedData> T get(VersionedDataKind<T> kind, String key) {
        Map<String, VersionedData> items = this.allData.get(kind);
        if (items == null) {
            logger.debug("[get] no objects exist for \"{}\". Returning null", (Object)kind.getNamespace());
            return null;
        }
        VersionedData o = items.get(key);
        if (o == null) {
            logger.debug("[get] Key: {} not found in \"{}\". Returning null", (Object)key, (Object)kind.getNamespace());
            return null;
        }
        if (!kind.getItemClass().isInstance(o)) {
            logger.warn("[get] Unexpected object class {} found for key: {} in \"{}\". Returning null", new Object[]{o.getClass().getName(), key, kind.getNamespace()});
            return null;
        }
        VersionedData item = (VersionedData)kind.getItemClass().cast(o);
        if (item.isDeleted()) {
            logger.debug("[get] Key: {} has been deleted. Returning null", (Object)key);
            return null;
        }
        logger.debug("[get] Key: {} with version: {} found in \"{}\".", new Object[]{key, item.getVersion(), kind.getNamespace()});
        return (T)item;
    }

    @Override
    public <T extends VersionedData> Map<String, T> all(VersionedDataKind<T> kind) {
        HashMap<String, T> fs = new HashMap<String, T>();
        Map<String, VersionedData> items = this.allData.get(kind);
        if (items != null) {
            for (Map.Entry<String, VersionedData> entry : items.entrySet()) {
                if (entry.getValue().isDeleted()) continue;
                fs.put(entry.getKey(), kind.getItemClass().cast(entry.getValue()));
            }
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> allData) {
        Object object = this.writeLock;
        synchronized (object) {
            ImmutableMap.Builder<VersionedDataKind<?>, ImmutableMap<String, ? extends VersionedData>> newData = ImmutableMap.builder();
            for (Map.Entry<VersionedDataKind<?>, Map<String, VersionedData>> entry : allData.entrySet()) {
                newData.put(entry.getKey(), ImmutableMap.copyOf(entry.getValue()));
            }
            this.allData = newData.build();
            this.initialized = true;
        }
    }

    @Override
    public <T extends VersionedData> void delete(VersionedDataKind<T> kind, String key, int version) {
        this.upsert(kind, kind.makeDeletedItem(key, version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends VersionedData> void upsert(VersionedDataKind<T> kind, T item) {
        String key = item.getKey();
        Object object = this.writeLock;
        synchronized (object) {
            Map<String, VersionedData> existingItems = this.allData.get(kind);
            VersionedData oldItem = null;
            if (existingItems != null && (oldItem = existingItems.get(key)) != null && oldItem.getVersion() >= item.getVersion()) {
                return;
            }
            ImmutableMap.Builder newData = ImmutableMap.builder();
            for (Map.Entry e : this.allData.entrySet()) {
                if (((VersionedDataKind)e.getKey()).equals(kind)) continue;
                newData.put(e.getKey(), e.getValue());
            }
            if (existingItems == null) {
                newData.put(kind, ImmutableMap.of(key, item));
            } else {
                ImmutableMap.Builder<String, VersionedData> itemsBuilder = ImmutableMap.builder();
                if (oldItem == null) {
                    itemsBuilder.putAll(existingItems);
                } else {
                    for (Map.Entry<String, VersionedData> e : existingItems.entrySet()) {
                        if (e.getKey().equals(key)) continue;
                        itemsBuilder.put(e.getKey(), e.getValue());
                    }
                }
                itemsBuilder.put(key, item);
                newData.put(kind, itemsBuilder.build());
            }
            this.allData = newData.build();
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public LDValue describeConfiguration(LDConfig config) {
        return LDValue.of("memory");
    }
}

