/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.DefaultFeatureRequestor;
import com.launchdarkly.client.DiagnosticAccumulator;
import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.HttpErrorException;
import com.launchdarkly.client.JsonHelpers;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.Util;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.client.interfaces.HttpConfiguration;
import com.launchdarkly.client.interfaces.SerializationException;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.SettableFuture;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ConnectionErrorHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.UnsuccessfulResponseException;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StreamProcessor
implements UpdateProcessor {
    private static final String PUT = "put";
    private static final String PATCH = "patch";
    private static final String DELETE = "delete";
    private static final String INDIRECT_PUT = "indirect/put";
    private static final String INDIRECT_PATCH = "indirect/patch";
    private static final Logger logger = LoggerFactory.getLogger(StreamProcessor.class);
    private static final int DEAD_CONNECTION_INTERVAL_MS = 300000;
    private final FeatureStore store;
    private final HttpConfiguration httpConfig;
    private final Headers headers;
    @VisibleForTesting
    final URI streamUri;
    @VisibleForTesting
    final long initialReconnectDelayMillis;
    @VisibleForTesting
    final FeatureRequestor requestor;
    private final DiagnosticAccumulator diagnosticAccumulator;
    private final EventSourceCreator eventSourceCreator;
    private volatile EventSource es;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile long esStarted = 0L;
    private volatile boolean lastStoreUpdateFailed = false;
    ConnectionErrorHandler connectionErrorHandler = this.createDefaultConnectionErrorHandler();

    StreamProcessor(String sdkKey, HttpConfiguration httpConfig, FeatureRequestor requestor, FeatureStore featureStore, EventSourceCreator eventSourceCreator, DiagnosticAccumulator diagnosticAccumulator, URI streamUri, long initialReconnectDelayMillis) {
        this.store = featureStore;
        this.httpConfig = httpConfig;
        this.requestor = requestor;
        this.diagnosticAccumulator = diagnosticAccumulator;
        this.eventSourceCreator = eventSourceCreator != null ? eventSourceCreator : new DefaultEventSourceCreator();
        this.streamUri = streamUri;
        this.initialReconnectDelayMillis = initialReconnectDelayMillis;
        this.headers = Util.getHeadersBuilderFor(sdkKey, httpConfig).add("Accept", "text/event-stream").build();
    }

    private ConnectionErrorHandler createDefaultConnectionErrorHandler() {
        return new ConnectionErrorHandler(){

            @Override
            public ConnectionErrorHandler.Action onConnectionError(Throwable t) {
                StreamProcessor.this.recordStreamInit(true);
                if (t instanceof UnsuccessfulResponseException) {
                    int status = ((UnsuccessfulResponseException)t).getCode();
                    logger.error(Util.httpErrorMessage(status, "streaming connection", "will retry"));
                    if (!Util.isHttpErrorRecoverable(status)) {
                        return ConnectionErrorHandler.Action.SHUTDOWN;
                    }
                }
                StreamProcessor.this.esStarted = System.currentTimeMillis();
                return ConnectionErrorHandler.Action.PROCEED;
            }
        };
    }

    @Override
    public Future<Void> start() {
        final SettableFuture<Void> initFuture = SettableFuture.create();
        ConnectionErrorHandler wrappedConnectionErrorHandler = new ConnectionErrorHandler(){

            @Override
            public ConnectionErrorHandler.Action onConnectionError(Throwable t) {
                ConnectionErrorHandler.Action result = StreamProcessor.this.connectionErrorHandler.onConnectionError(t);
                if (result == ConnectionErrorHandler.Action.SHUTDOWN) {
                    initFuture.set(null);
                }
                return result;
            }
        };
        EventHandler handler = new EventHandler(){

            @Override
            public void onOpen() throws Exception {
            }

            @Override
            public void onClosed() throws Exception {
            }

            @Override
            public void onMessage(String name, MessageEvent event) {
                try {
                    switch (name) {
                        case "put": {
                            StreamProcessor.this.recordStreamInit(false);
                            StreamProcessor.this.esStarted = 0L;
                            PutData putData = (PutData)StreamProcessor.parseStreamJson(PutData.class, event.getData());
                            try {
                                StreamProcessor.this.store.init(DefaultFeatureRequestor.toVersionedDataMap(putData.data));
                            }
                            catch (Exception e) {
                                throw new StreamStoreException(e);
                            }
                            if (!StreamProcessor.this.initialized.getAndSet(true)) {
                                initFuture.set(null);
                                logger.info("Initialized LaunchDarkly client.");
                            }
                            break;
                        }
                        case "patch": {
                            PatchData data = (PatchData)StreamProcessor.parseStreamJson(PatchData.class, event.getData());
                            Map.Entry kindAndKey = StreamProcessor.getKindAndKeyFromStreamApiPath(data.path);
                            if (kindAndKey == null) break;
                            VersionedDataKind kind = (VersionedDataKind)kindAndKey.getKey();
                            VersionedData item = StreamProcessor.deserializeFromParsedJson(kind, data.data);
                            try {
                                StreamProcessor.this.store.upsert(kind, item);
                                break;
                            }
                            catch (Exception e) {
                                throw new StreamStoreException(e);
                            }
                        }
                        case "delete": {
                            DeleteData data = (DeleteData)StreamProcessor.parseStreamJson(DeleteData.class, event.getData());
                            Map.Entry kindAndKey = StreamProcessor.getKindAndKeyFromStreamApiPath(data.path);
                            if (kindAndKey == null) break;
                            VersionedDataKind kind = (VersionedDataKind)kindAndKey.getKey();
                            String key = (String)kindAndKey.getValue();
                            try {
                                StreamProcessor.this.store.delete(kind, key, data.version);
                                break;
                            }
                            catch (Exception e) {
                                throw new StreamStoreException(e);
                            }
                        }
                        case "indirect/put": {
                            FeatureRequestor.AllData allData;
                            try {
                                allData = StreamProcessor.this.requestor.getAllData();
                            }
                            catch (HttpErrorException e) {
                                throw new StreamInputException(e);
                            }
                            catch (IOException e) {
                                throw new StreamInputException(e);
                            }
                            try {
                                StreamProcessor.this.store.init(DefaultFeatureRequestor.toVersionedDataMap(allData));
                            }
                            catch (Exception e) {
                                throw new StreamStoreException(e);
                            }
                            if (!StreamProcessor.this.initialized.getAndSet(true)) {
                                initFuture.set(null);
                                logger.info("Initialized LaunchDarkly client.");
                            }
                            break;
                        }
                        case "indirect/patch": {
                            VersionedData item;
                            String path = event.getData();
                            Map.Entry kindAndKey = StreamProcessor.getKindAndKeyFromStreamApiPath(path);
                            if (kindAndKey == null) break;
                            VersionedDataKind kind = (VersionedDataKind)kindAndKey.getKey();
                            String key = (String)kindAndKey.getValue();
                            try {
                                item = kind == VersionedDataKind.SEGMENTS ? StreamProcessor.this.requestor.getSegment(key) : StreamProcessor.this.requestor.getFlag(key);
                            }
                            catch (Exception e) {
                                throw new StreamInputException(e);
                            }
                            try {
                                StreamProcessor.this.store.upsert(kind, item);
                                break;
                            }
                            catch (Exception e) {
                                throw new StreamStoreException(e);
                            }
                        }
                        default: {
                            logger.warn("Unexpected event found in stream: " + event.getData());
                        }
                    }
                }
                catch (StreamInputException e) {
                    logger.error("LaunchDarkly service request failed or received invalid data: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                    StreamProcessor.this.es.restart();
                }
                catch (StreamStoreException e) {
                    if (!StreamProcessor.this.lastStoreUpdateFailed) {
                        logger.error("Unexpected data store failure when storing updates from stream: {}", (Object)e.getCause().toString());
                        logger.debug(e.getCause().toString(), e.getCause());
                        StreamProcessor.this.lastStoreUpdateFailed = true;
                    }
                    StreamProcessor.this.es.restart();
                }
                catch (Exception e) {
                    logger.error("Unexpected exception in stream processor: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                }
            }

            @Override
            public void onComment(String comment) {
                logger.debug("Received a heartbeat");
            }

            @Override
            public void onError(Throwable throwable) {
                logger.warn("Encountered EventSource error: {}", (Object)throwable.toString());
                logger.debug(throwable.toString(), throwable);
            }
        };
        this.es = this.eventSourceCreator.createEventSource(handler, URI.create(this.streamUri.toASCIIString() + "/all"), this.initialReconnectDelayMillis, wrappedConnectionErrorHandler, this.headers, this.httpConfig);
        this.esStarted = System.currentTimeMillis();
        this.es.start();
        return initFuture;
    }

    private void recordStreamInit(boolean failed) {
        if (this.diagnosticAccumulator != null && this.esStarted != 0L) {
            this.diagnosticAccumulator.recordStreamInit(this.esStarted, System.currentTimeMillis() - this.esStarted, failed);
        }
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly StreamProcessor");
        if (this.es != null) {
            this.es.close();
        }
        if (this.store != null) {
            this.store.close();
        }
        this.requestor.close();
    }

    @Override
    public boolean initialized() {
        return this.initialized.get();
    }

    private static Map.Entry<VersionedDataKind<VersionedData>, String> getKindAndKeyFromStreamApiPath(String path) throws StreamInputException {
        if (path == null) {
            throw new StreamInputException("missing item path");
        }
        for (VersionedDataKind<?> kind : VersionedDataKind.ALL) {
            String prefix = kind == VersionedDataKind.SEGMENTS ? "/segments/" : "/flags/";
            if (!path.startsWith(prefix)) continue;
            return new AbstractMap.SimpleEntry<VersionedDataKind<VersionedData>, String>(kind, path.substring(prefix.length()));
        }
        return null;
    }

    private static <T> T parseStreamJson(Class<T> c, String json) throws StreamInputException {
        try {
            return JsonHelpers.deserialize(json, c);
        }
        catch (SerializationException e) {
            throw new StreamInputException(e);
        }
    }

    private static VersionedData deserializeFromParsedJson(VersionedDataKind<?> kind, JsonElement parsedJson) throws StreamInputException {
        try {
            return JsonHelpers.deserializeFromParsedJson(kind, parsedJson);
        }
        catch (SerializationException e) {
            throw new StreamInputException(e);
        }
    }

    private class DefaultEventSourceCreator
    implements EventSourceCreator {
        private DefaultEventSourceCreator() {
        }

        @Override
        public EventSource createEventSource(EventHandler handler, URI streamUri, long initialReconnectDelayMillis, ConnectionErrorHandler errorHandler, Headers headers, final HttpConfiguration httpConfig) {
            EventSource.Builder builder = new EventSource.Builder(handler, streamUri).clientBuilderActions(new EventSource.Builder.ClientConfigurer(){

                @Override
                public void configure(OkHttpClient.Builder builder) {
                    Util.configureHttpClientBuilder(httpConfig, builder);
                }
            }).connectionErrorHandler(errorHandler).headers(headers).reconnectTimeMs(initialReconnectDelayMillis).readTimeoutMs(300000).connectTimeoutMs(10000).writeTimeoutMs(5000);
            return builder.build();
        }
    }

    private static final class DeleteData {
        String path;
        int version;
    }

    private static final class PatchData {
        String path;
        JsonElement data;
    }

    private static final class PutData {
        FeatureRequestor.AllData data;
    }

    private static final class StreamStoreException
    extends Exception {
        public StreamStoreException(Throwable cause) {
            super(cause);
        }
    }

    private static final class StreamInputException
    extends Exception {
        public StreamInputException(String message) {
            super(message);
        }

        public StreamInputException(Throwable cause) {
            super(cause);
        }
    }

    public static interface EventSourceCreator {
        public EventSource createEventSource(EventHandler var1, URI var2, long var3, ConnectionErrorHandler var5, Headers var6, HttpConfiguration var7);
    }
}

