/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.interfaces.HttpAuthentication;
import com.launchdarkly.client.interfaces.HttpConfiguration;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.shaded.com.google.common.base.Function;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.Challenge;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import com.launchdarkly.shaded.okhttp3.Route;
import com.launchdarkly.shaded.org.joda.time.DateTime;
import com.launchdarkly.shaded.org.joda.time.DateTimeZone;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

class Util {
    Util() {
    }

    static DateTime jsonPrimitiveToDateTime(LDValue maybeDate) {
        if (maybeDate.isNumber()) {
            return new DateTime((long)maybeDate.doubleValue());
        }
        if (maybeDate.isString()) {
            try {
                return new DateTime((Object)maybeDate.stringValue(), DateTimeZone.UTC);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    static Headers.Builder getHeadersBuilderFor(String sdkKey, HttpConfiguration config) {
        Headers.Builder builder = new Headers.Builder().add("Authorization", sdkKey).add("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
        if (config.getWrapperIdentifier() != null) {
            builder.add("X-LaunchDarkly-Wrapper", config.getWrapperIdentifier());
        }
        return builder;
    }

    static void configureHttpClientBuilder(HttpConfiguration config, OkHttpClient.Builder builder) {
        builder.connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(config.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS).readTimeout(config.getSocketTimeoutMillis(), TimeUnit.MILLISECONDS).writeTimeout(config.getSocketTimeoutMillis(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(false);
        if (config.getSslSocketFactory() != null) {
            builder.sslSocketFactory(config.getSslSocketFactory(), config.getTrustManager());
        }
        if (config.getProxy() != null) {
            builder.proxy(config.getProxy());
            if (config.getProxyAuthentication() != null) {
                builder.proxyAuthenticator(Util.okhttpAuthenticatorFromHttpAuthStrategy(config.getProxyAuthentication(), "Proxy-Authentication", "Proxy-Authorization"));
            }
        }
    }

    static final Authenticator okhttpAuthenticatorFromHttpAuthStrategy(final HttpAuthentication strategy, String challengeHeaderName, final String responseHeaderName) {
        return new Authenticator(){

            @Override
            public Request authenticate(Route route, Response response) throws IOException {
                if (response.request().header(responseHeaderName) != null) {
                    return null;
                }
                Iterable<HttpAuthentication.Challenge> challenges = Iterables.transform(response.challenges(), new Function<Challenge, HttpAuthentication.Challenge>(){

                    @Override
                    public HttpAuthentication.Challenge apply(Challenge c) {
                        return new HttpAuthentication.Challenge(c.scheme(), c.realm());
                    }
                });
                String credential = strategy.provideAuthorization(challenges);
                return response.request().newBuilder().header(responseHeaderName, credential).build();
            }
        };
    }

    static void shutdownHttpClient(OkHttpClient client) {
        if (client.dispatcher() != null) {
            client.dispatcher().cancelAll();
            if (client.dispatcher().executorService() != null) {
                client.dispatcher().executorService().shutdown();
            }
        }
        if (client.connectionPool() != null) {
            client.connectionPool().evictAll();
        }
        if (client.cache() != null) {
            try {
                client.cache().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isHttpErrorRecoverable(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 400: 
                case 408: 
                case 429: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    static String httpErrorMessage(int statusCode, String context, String recoverableMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("Received HTTP error ").append(statusCode);
        switch (statusCode) {
            case 401: 
            case 403: {
                sb.append(" (invalid SDK key)");
            }
        }
        sb.append(" for ").append(context).append(" - ");
        sb.append(Util.isHttpErrorRecoverable(statusCode) ? recoverableMessage : "giving up permanently");
        return sb.toString();
    }
}

