/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Event;
import com.launchdarkly.client.value.LDValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class EventSummarizer {
    private EventSummary eventsState = new EventSummary();

    EventSummarizer() {
    }

    void summarizeEvent(Event event) {
        if (event instanceof Event.FeatureRequest) {
            Event.FeatureRequest fe = (Event.FeatureRequest)event;
            this.eventsState.incrementCounter(fe.key, fe.variation, fe.version, fe.value, fe.defaultVal);
            this.eventsState.noteTimestamp(fe.creationDate);
        }
    }

    EventSummary snapshot() {
        return new EventSummary(this.eventsState);
    }

    void clear() {
        this.eventsState = new EventSummary();
    }

    static final class CounterValue {
        long count;
        final LDValue flagValue;
        final LDValue defaultVal;

        CounterValue(long count, LDValue flagValue, LDValue defaultVal) {
            this.count = count;
            this.flagValue = flagValue;
            this.defaultVal = defaultVal;
        }

        void increment() {
            ++this.count;
        }

        public boolean equals(Object other) {
            if (other instanceof CounterValue) {
                CounterValue o = (CounterValue)other;
                return this.count == o.count && Objects.equals(this.flagValue, o.flagValue) && Objects.equals(this.defaultVal, o.defaultVal);
            }
            return false;
        }

        public String toString() {
            return "(" + this.count + "," + this.flagValue + "," + this.defaultVal + ")";
        }
    }

    static final class CounterKey {
        final String key;
        final Integer variation;
        final Integer version;

        CounterKey(String key, Integer variation, Integer version) {
            this.key = key;
            this.variation = variation;
            this.version = version;
        }

        public boolean equals(Object other) {
            if (other instanceof CounterKey) {
                CounterKey o = (CounterKey)other;
                return o.key.equals(this.key) && Objects.equals(o.variation, this.variation) && Objects.equals(o.version, this.version);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode() + 31 * (Objects.hashCode(this.variation) + 31 * Objects.hashCode(this.version));
        }

        public String toString() {
            return "(" + this.key + "," + this.variation + "," + this.version + ")";
        }
    }

    static final class EventSummary {
        final Map<CounterKey, CounterValue> counters;
        long startDate;
        long endDate;

        EventSummary() {
            this.counters = new HashMap<CounterKey, CounterValue>();
        }

        EventSummary(EventSummary from) {
            this.counters = new HashMap<CounterKey, CounterValue>(from.counters);
            this.startDate = from.startDate;
            this.endDate = from.endDate;
        }

        boolean isEmpty() {
            return this.counters.isEmpty();
        }

        void incrementCounter(String flagKey, Integer variation, Integer version, LDValue flagValue, LDValue defaultVal) {
            CounterKey key = new CounterKey(flagKey, variation, version);
            CounterValue value = this.counters.get(key);
            if (value != null) {
                value.increment();
            } else {
                this.counters.put(key, new CounterValue(1L, flagValue, defaultVal));
            }
        }

        void noteTimestamp(long time) {
            if (this.startDate == 0L || time < this.startDate) {
                this.startDate = time;
            }
            if (time > this.endDate) {
                this.endDate = time;
            }
        }

        public boolean equals(Object other) {
            if (other instanceof EventSummary) {
                EventSummary o = (EventSummary)other;
                return o.counters.equals(this.counters) && this.startDate == o.startDate && this.endDate == o.endDate;
            }
            return true;
        }

        public int hashCode() {
            return this.counters.hashCode() + 31 * ((int)this.startDate + 31 * (int)this.endDate);
        }
    }
}

