/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.SemanticVersion;
import com.launchdarkly.client.Util;
import com.launchdarkly.client.value.LDValue;

enum OperandType {
    string,
    number,
    date,
    semVer;


    public static OperandType bestGuess(LDValue value) {
        return value.isNumber() ? number : string;
    }

    public Object getValueAsType(LDValue value) {
        switch (this) {
            case string: {
                return value.stringValue();
            }
            case number: {
                return value.isNumber() ? Double.valueOf(value.doubleValue()) : null;
            }
            case date: {
                return Util.jsonPrimitiveToDateTime(value);
            }
            case semVer: {
                if (!value.isString()) {
                    return null;
                }
                try {
                    return SemanticVersion.parse(value.stringValue(), true);
                }
                catch (SemanticVersion.InvalidVersionException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

