/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.integrations;

import com.google.gson.JsonElement;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.client.integrations.FileDataSourceParsing;
import com.launchdarkly.shaded.com.google.common.util.concurrent.Futures;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileDataSourceImpl
implements UpdateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FileDataSourceImpl.class);
    private final FeatureStore store;
    private final DataLoader dataLoader;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final FileWatcher fileWatcher;

    FileDataSourceImpl(FeatureStore store, List<Path> sources, boolean autoUpdate) {
        this.store = store;
        this.dataLoader = new DataLoader(sources);
        FileWatcher fw = null;
        if (autoUpdate) {
            try {
                fw = FileWatcher.create(this.dataLoader.getFiles());
            }
            catch (IOException e) {
                logger.error("Unable to watch files for auto-updating: " + e);
                fw = null;
            }
        }
        this.fileWatcher = fw;
    }

    @Override
    public Future<Void> start() {
        ListenableFuture<Object> initFuture = Futures.immediateFuture(null);
        this.reload();
        if (this.fileWatcher != null) {
            this.fileWatcher.start(new Runnable(){

                @Override
                public void run() {
                    FileDataSourceImpl.this.reload();
                }
            });
        }
        return initFuture;
    }

    private boolean reload() {
        DataBuilder builder = new DataBuilder();
        try {
            this.dataLoader.load(builder);
        }
        catch (FileDataSourceParsing.FileDataException e) {
            logger.error(e.getDescription());
            return false;
        }
        this.store.init(builder.build());
        this.inited.set(true);
        return true;
    }

    @Override
    public boolean initialized() {
        return this.inited.get();
    }

    @Override
    public void close() throws IOException {
        if (this.fileWatcher != null) {
            this.fileWatcher.stop();
        }
    }

    static final class DataBuilder {
        private final Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> allData = new HashMap();

        DataBuilder() {
        }

        public Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> build() {
            return this.allData;
        }

        public void add(VersionedDataKind<?> kind, VersionedData item) throws FileDataSourceParsing.FileDataException {
            Map<String, ? extends VersionedData> items = this.allData.get(kind);
            if (items == null) {
                items = new HashMap<String, VersionedData>();
                this.allData.put(kind, items);
            }
            if (items.containsKey(item.getKey())) {
                throw new FileDataSourceParsing.FileDataException("in " + kind.getNamespace() + ", key \"" + item.getKey() + "\" was already defined", null, null);
            }
            items.put(item.getKey(), item);
        }
    }

    static final class DataLoader {
        private final List<Path> files;

        public DataLoader(List<Path> files) {
            this.files = new ArrayList<Path>(files);
        }

        public Iterable<Path> getFiles() {
            return this.files;
        }

        public void load(DataBuilder builder) throws FileDataSourceParsing.FileDataException {
            for (Path p : this.files) {
                try {
                    byte[] data = Files.readAllBytes(p);
                    FileDataSourceParsing.FlagFileParser parser = FileDataSourceParsing.FlagFileParser.selectForContent(data);
                    FileDataSourceParsing.FlagFileRep fileContents = parser.parse(new ByteArrayInputStream(data));
                    if (fileContents.flags != null) {
                        for (Map.Entry<String, JsonElement> e : fileContents.flags.entrySet()) {
                            builder.add(VersionedDataKind.FEATURES, FileDataSourceParsing.FlagFactory.flagFromJson(e.getValue()));
                        }
                    }
                    if (fileContents.flagValues != null) {
                        for (Map.Entry<String, JsonElement> e : fileContents.flagValues.entrySet()) {
                            builder.add(VersionedDataKind.FEATURES, FileDataSourceParsing.FlagFactory.flagWithValue(e.getKey(), e.getValue()));
                        }
                    }
                    if (fileContents.segments == null) continue;
                    for (Map.Entry<String, JsonElement> e : fileContents.segments.entrySet()) {
                        builder.add(VersionedDataKind.SEGMENTS, FileDataSourceParsing.FlagFactory.segmentFromJson(e.getValue()));
                    }
                }
                catch (FileDataSourceParsing.FileDataException e) {
                    throw new FileDataSourceParsing.FileDataException(e.getMessage(), e.getCause(), p);
                }
                catch (IOException e) {
                    throw new FileDataSourceParsing.FileDataException(null, e, p);
                }
            }
        }
    }

    private static final class FileWatcher
    implements Runnable {
        private final WatchService watchService;
        private final Set<Path> watchedFilePaths;
        private Runnable fileModifiedAction;
        private Thread thread;
        private volatile boolean stopped;

        private static FileWatcher create(Iterable<Path> files) throws IOException {
            HashSet<Path> directoryPaths = new HashSet<Path>();
            HashSet<Path> absoluteFilePaths = new HashSet<Path>();
            FileSystem fs = FileSystems.getDefault();
            WatchService ws = fs.newWatchService();
            for (Path p : files) {
                absoluteFilePaths.add(p);
                directoryPaths.add(p.getParent());
            }
            for (Path d : directoryPaths) {
                d.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
            return new FileWatcher(ws, absoluteFilePaths);
        }

        private FileWatcher(WatchService watchService, Set<Path> watchedFilePaths) {
            this.watchService = watchService;
            this.watchedFilePaths = watchedFilePaths;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    WatchKey key = this.watchService.take();
                    boolean watchedFileWasChanged = false;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path fileNamePath;
                        Path dirPath;
                        Path absolutePath;
                        Watchable w = key.watchable();
                        Object context = event.context();
                        if (!(w instanceof Path) || !(context instanceof Path) || !this.watchedFilePaths.contains(absolutePath = (dirPath = (Path)w).resolve(fileNamePath = (Path)context))) continue;
                        watchedFileWasChanged = true;
                        break;
                    }
                    if (watchedFileWasChanged) {
                        try {
                            this.fileModifiedAction.run();
                        }
                        catch (Exception e) {
                            logger.warn("Unexpected exception when reloading file data: " + e);
                        }
                    }
                    key.reset();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void start(Runnable fileModifiedAction) {
            this.fileModifiedAction = fileModifiedAction;
            this.thread = new Thread((Runnable)this, FileDataSourceImpl.class.getName());
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public void stop() {
            this.stopped = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

