/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.integrations;

import com.launchdarkly.client.interfaces.HttpAuthentication;
import com.launchdarkly.client.interfaces.HttpConfigurationFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public abstract class HttpConfigurationBuilder
implements HttpConfigurationFactory {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 10000;
    protected int connectTimeoutMillis = 2000;
    protected HttpAuthentication proxyAuth;
    protected String proxyHost;
    protected int proxyPort;
    protected int socketTimeoutMillis = 10000;
    protected SSLSocketFactory sslSocketFactory;
    protected X509TrustManager trustManager;
    protected String wrapperName;
    protected String wrapperVersion;

    public HttpConfigurationBuilder connectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public HttpConfigurationBuilder proxyHostAndPort(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        return this;
    }

    public HttpConfigurationBuilder proxyAuth(HttpAuthentication strategy) {
        this.proxyAuth = strategy;
        return this;
    }

    public HttpConfigurationBuilder socketTimeoutMillis(int socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis;
        return this;
    }

    public HttpConfigurationBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.sslSocketFactory = sslSocketFactory;
        this.trustManager = trustManager;
        return this;
    }

    public HttpConfigurationBuilder wrapper(String wrapperName, String wrapperVersion) {
        this.wrapperName = wrapperName;
        this.wrapperVersion = wrapperVersion;
        return this;
    }
}

