/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.integrations;

import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.integrations.RedisDataStoreImpl;
import com.launchdarkly.client.interfaces.DiagnosticDescription;
import com.launchdarkly.client.interfaces.PersistentDataStoreFactory;
import com.launchdarkly.client.utils.FeatureStoreCore;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.shaded.com.google.common.base.Joiner;
import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public final class RedisDataStoreBuilder
implements PersistentDataStoreFactory,
DiagnosticDescription {
    public static final URI DEFAULT_URI = RedisDataStoreBuilder.makeDefaultRedisURI();
    public static final String DEFAULT_PREFIX = "launchdarkly";
    URI uri = DEFAULT_URI;
    String prefix = "launchdarkly";
    int connectTimeout = 2000;
    int socketTimeout = 2000;
    Integer database = null;
    String password = null;
    boolean tls = false;
    JedisPoolConfig poolConfig = null;

    private static URI makeDefaultRedisURI() {
        return URI.create(Joiner.on("").join("r", "e", "d", "i", "s") + "://localhost:6379");
    }

    RedisDataStoreBuilder() {
    }

    public RedisDataStoreBuilder database(Integer database) {
        this.database = database;
        return this;
    }

    public RedisDataStoreBuilder password(String password) {
        this.password = password;
        return this;
    }

    public RedisDataStoreBuilder tls(boolean tls) {
        this.tls = tls;
        return this;
    }

    public RedisDataStoreBuilder uri(URI redisUri) {
        this.uri = Preconditions.checkNotNull(redisUri);
        return this;
    }

    public RedisDataStoreBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public RedisDataStoreBuilder poolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public RedisDataStoreBuilder connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = (int)timeUnit.toMillis(connectTimeout);
        return this;
    }

    public RedisDataStoreBuilder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
        this.socketTimeout = (int)timeUnit.toMillis(socketTimeout);
        return this;
    }

    @Override
    public FeatureStoreCore createPersistentDataStore() {
        return new RedisDataStoreImpl(this);
    }

    @Override
    public LDValue describeConfiguration(LDConfig config) {
        return LDValue.of("Redis");
    }
}

