/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Components;
import com.launchdarkly.client.EventProcessorFactory;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.UpdateProcessorFactory;
import com.launchdarkly.client.interfaces.HttpConfiguration;
import com.launchdarkly.client.interfaces.HttpConfigurationFactory;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import java.net.URI;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public final class LDConfig {
    static final URI DEFAULT_BASE_URI = URI.create("https://app.launchdarkly.com");
    static final URI DEFAULT_EVENTS_URI = URI.create("https://events.launchdarkly.com");
    static final URI DEFAULT_STREAM_URI = URI.create("https://stream.launchdarkly.com");
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int DEFAULT_FLUSH_INTERVAL_SECONDS = 5;
    private static final long MIN_POLLING_INTERVAL_MILLIS = 30000L;
    private static final long DEFAULT_START_WAIT_MILLIS = 5000L;
    private static final int DEFAULT_SAMPLING_INTERVAL = 0;
    private static final int DEFAULT_USER_KEYS_CAPACITY = 1000;
    private static final int DEFAULT_USER_KEYS_FLUSH_INTERVAL_SECONDS = 300;
    private static final long DEFAULT_RECONNECT_TIME_MILLIS = 1000L;
    protected static final LDConfig DEFAULT = new Builder().build();
    final UpdateProcessorFactory dataSourceFactory;
    final FeatureStoreFactory dataStoreFactory;
    final boolean diagnosticOptOut;
    final EventProcessorFactory eventProcessorFactory;
    final HttpConfiguration httpConfig;
    final boolean offline;
    final long startWaitMillis;
    final URI deprecatedBaseURI;
    final URI deprecatedEventsURI;
    final URI deprecatedStreamURI;
    final int deprecatedCapacity;
    final int deprecatedFlushInterval;
    final boolean deprecatedStream;
    final FeatureStore deprecatedFeatureStore;
    final boolean deprecatedAllAttributesPrivate;
    final ImmutableSet<String> deprecatedPrivateAttrNames;
    final boolean deprecatedSendEvents;
    final long deprecatedPollingIntervalMillis;
    final int deprecatedSamplingInterval;
    final long deprecatedReconnectTimeMs;
    final int deprecatedUserKeysCapacity;
    final int deprecatedUserKeysFlushInterval;
    final boolean deprecatedInlineUsersInEvents;

    protected LDConfig(Builder builder) {
        this.dataStoreFactory = builder.dataStoreFactory;
        this.eventProcessorFactory = builder.eventProcessorFactory;
        this.dataSourceFactory = builder.dataSourceFactory;
        this.diagnosticOptOut = builder.diagnosticOptOut;
        this.offline = builder.offline;
        this.startWaitMillis = builder.startWaitMillis;
        this.httpConfig = builder.httpConfigFactory != null ? builder.httpConfigFactory.createHttpConfiguration() : Components.httpConfiguration().connectTimeoutMillis(builder.connectTimeoutMillis).proxyHostAndPort(builder.proxyPort == -1 ? null : builder.proxyHost, builder.proxyPort).proxyAuth(builder.proxyUsername == null || builder.proxyPassword == null ? null : Components.httpBasicAuthentication(builder.proxyUsername, builder.proxyPassword)).socketTimeoutMillis(builder.socketTimeoutMillis).sslSocketFactory(builder.sslSocketFactory, builder.trustManager).wrapper(builder.wrapperName, builder.wrapperVersion).createHttpConfiguration();
        this.deprecatedAllAttributesPrivate = builder.allAttributesPrivate;
        this.deprecatedBaseURI = builder.baseURI;
        this.deprecatedCapacity = builder.capacity;
        this.deprecatedEventsURI = builder.eventsURI;
        this.deprecatedFeatureStore = builder.featureStore;
        this.deprecatedFlushInterval = builder.flushIntervalSeconds;
        this.deprecatedInlineUsersInEvents = builder.inlineUsersInEvents;
        this.deprecatedPollingIntervalMillis = builder.pollingIntervalMillis < 30000L ? 30000L : builder.pollingIntervalMillis;
        this.deprecatedPrivateAttrNames = builder.privateAttrNames;
        this.deprecatedSendEvents = builder.sendEvents;
        this.deprecatedStream = builder.stream;
        this.deprecatedStreamURI = builder.streamURI;
        this.deprecatedSamplingInterval = builder.samplingInterval;
        this.deprecatedReconnectTimeMs = builder.reconnectTimeMillis;
        this.deprecatedUserKeysCapacity = builder.userKeysCapacity;
        this.deprecatedUserKeysFlushInterval = builder.userKeysFlushInterval;
    }

    LDConfig(LDConfig config) {
        this.dataSourceFactory = config.dataSourceFactory;
        this.dataStoreFactory = config.dataStoreFactory;
        this.diagnosticOptOut = config.diagnosticOptOut;
        this.eventProcessorFactory = config.eventProcessorFactory;
        this.httpConfig = config.httpConfig;
        this.offline = config.offline;
        this.startWaitMillis = config.startWaitMillis;
        this.deprecatedAllAttributesPrivate = config.deprecatedAllAttributesPrivate;
        this.deprecatedBaseURI = config.deprecatedBaseURI;
        this.deprecatedCapacity = config.deprecatedCapacity;
        this.deprecatedEventsURI = config.deprecatedEventsURI;
        this.deprecatedFeatureStore = config.deprecatedFeatureStore;
        this.deprecatedFlushInterval = config.deprecatedFlushInterval;
        this.deprecatedInlineUsersInEvents = config.deprecatedInlineUsersInEvents;
        this.deprecatedPollingIntervalMillis = config.deprecatedPollingIntervalMillis;
        this.deprecatedPrivateAttrNames = config.deprecatedPrivateAttrNames;
        this.deprecatedReconnectTimeMs = config.deprecatedReconnectTimeMs;
        this.deprecatedSamplingInterval = config.deprecatedSamplingInterval;
        this.deprecatedSendEvents = config.deprecatedSendEvents;
        this.deprecatedStream = config.deprecatedStream;
        this.deprecatedStreamURI = config.deprecatedStreamURI;
        this.deprecatedUserKeysCapacity = config.deprecatedUserKeysCapacity;
        this.deprecatedUserKeysFlushInterval = config.deprecatedUserKeysFlushInterval;
    }

    public static class Builder {
        private URI baseURI = DEFAULT_BASE_URI;
        private URI eventsURI = DEFAULT_EVENTS_URI;
        private URI streamURI = DEFAULT_STREAM_URI;
        private HttpConfigurationFactory httpConfigFactory = null;
        private int connectTimeoutMillis = 2000;
        private int socketTimeoutMillis = 10000;
        private boolean diagnosticOptOut = false;
        private int capacity = 10000;
        private int flushIntervalSeconds = 5;
        private String proxyHost = "localhost";
        private int proxyPort = -1;
        private String proxyUsername = null;
        private String proxyPassword = null;
        private boolean stream = true;
        private boolean offline = false;
        private boolean allAttributesPrivate = false;
        private boolean sendEvents = true;
        private long pollingIntervalMillis = 30000L;
        private FeatureStore featureStore = null;
        private FeatureStoreFactory dataStoreFactory = null;
        private EventProcessorFactory eventProcessorFactory = null;
        private UpdateProcessorFactory dataSourceFactory = null;
        private long startWaitMillis = 5000L;
        private int samplingInterval = 0;
        private long reconnectTimeMillis = 1000L;
        private ImmutableSet<String> privateAttrNames = ImmutableSet.of();
        private int userKeysCapacity = 1000;
        private int userKeysFlushInterval = 300;
        private boolean inlineUsersInEvents = false;
        private SSLSocketFactory sslSocketFactory = null;
        private X509TrustManager trustManager = null;
        private String wrapperName = null;
        private String wrapperVersion = null;

        @Deprecated
        public Builder baseURI(URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        @Deprecated
        public Builder eventsURI(URI eventsURI) {
            this.eventsURI = eventsURI;
            return this;
        }

        @Deprecated
        public Builder streamURI(URI streamURI) {
            this.streamURI = streamURI;
            return this;
        }

        public Builder dataStore(FeatureStoreFactory factory) {
            this.dataStoreFactory = factory;
            return this;
        }

        @Deprecated
        public Builder featureStore(FeatureStore store) {
            this.featureStore = store;
            return this;
        }

        @Deprecated
        public Builder featureStoreFactory(FeatureStoreFactory factory) {
            this.dataStoreFactory = factory;
            return this;
        }

        public Builder events(EventProcessorFactory factory) {
            this.eventProcessorFactory = factory;
            return this;
        }

        @Deprecated
        public Builder eventProcessorFactory(EventProcessorFactory factory) {
            this.eventProcessorFactory = factory;
            return this;
        }

        public Builder dataSource(UpdateProcessorFactory factory) {
            this.dataSourceFactory = factory;
            return this;
        }

        @Deprecated
        public Builder updateProcessorFactory(UpdateProcessorFactory factory) {
            this.dataSourceFactory = factory;
            return this;
        }

        @Deprecated
        public Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder http(HttpConfigurationFactory factory) {
            this.httpConfigFactory = factory;
            return this;
        }

        @Deprecated
        public Builder connectTimeout(int connectTimeout) {
            return this.connectTimeoutMillis(connectTimeout * 1000);
        }

        @Deprecated
        public Builder socketTimeout(int socketTimeout) {
            return this.socketTimeoutMillis(socketTimeout * 1000);
        }

        @Deprecated
        public Builder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        @Deprecated
        public Builder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        @Deprecated
        public Builder flushInterval(int flushInterval) {
            this.flushIntervalSeconds = flushInterval;
            return this;
        }

        @Deprecated
        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        @Deprecated
        public Builder proxyHost(String host) {
            this.proxyHost = host;
            return this;
        }

        @Deprecated
        public Builder proxyPort(int port) {
            this.proxyPort = port;
            return this;
        }

        @Deprecated
        public Builder proxyUsername(String username) {
            this.proxyUsername = username;
            return this;
        }

        @Deprecated
        public Builder proxyPassword(String password) {
            this.proxyPassword = password;
            return this;
        }

        @Deprecated
        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.trustManager = trustManager;
            return this;
        }

        @Deprecated
        public Builder useLdd(boolean useLdd) {
            if (useLdd) {
                return this.dataSource(Components.externalUpdatesOnly());
            }
            return this.dataSource(null);
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        @Deprecated
        public Builder allAttributesPrivate(boolean allPrivate) {
            this.allAttributesPrivate = allPrivate;
            return this;
        }

        @Deprecated
        public Builder sendEvents(boolean sendEvents) {
            this.sendEvents = sendEvents;
            return this;
        }

        @Deprecated
        public Builder pollingIntervalMillis(long pollingIntervalMillis) {
            this.pollingIntervalMillis = pollingIntervalMillis;
            return this;
        }

        public Builder startWaitMillis(long startWaitMillis) {
            this.startWaitMillis = startWaitMillis;
            return this;
        }

        @Deprecated
        public Builder samplingInterval(int samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        @Deprecated
        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMillis = reconnectTimeMs;
            return this;
        }

        @Deprecated
        public Builder privateAttributeNames(String ... names) {
            this.privateAttrNames = ImmutableSet.copyOf(names);
            return this;
        }

        @Deprecated
        public Builder userKeysCapacity(int capacity) {
            this.userKeysCapacity = capacity;
            return this;
        }

        @Deprecated
        public Builder userKeysFlushInterval(int flushInterval) {
            this.userKeysFlushInterval = flushInterval;
            return this;
        }

        @Deprecated
        public Builder inlineUsersInEvents(boolean inlineUsersInEvents) {
            this.inlineUsersInEvents = inlineUsersInEvents;
            return this;
        }

        public Builder diagnosticOptOut(boolean diagnosticOptOut) {
            this.diagnosticOptOut = diagnosticOptOut;
            return this;
        }

        @Deprecated
        public Builder wrapperName(String wrapperName) {
            this.wrapperName = wrapperName;
            return this;
        }

        @Deprecated
        public Builder wrapperVersion(String wrapperVersion) {
            this.wrapperVersion = wrapperVersion;
            return this;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

