/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.integrations;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.org.yaml.snakeyaml.Yaml;
import com.launchdarkly.shaded.org.yaml.snakeyaml.error.YAMLException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Map;

abstract class FileDataSourceParsing {
    FileDataSourceParsing() {
    }

    static final class FlagFactory {
        private static final Gson gson = new Gson();

        FlagFactory() {
        }

        static VersionedData flagFromJson(String jsonString) {
            return FlagFactory.flagFromJson((JsonElement)gson.fromJson(jsonString, JsonElement.class));
        }

        static VersionedData flagFromJson(JsonElement jsonTree) {
            return (VersionedData)gson.fromJson(jsonTree, VersionedDataKind.FEATURES.getItemClass());
        }

        static VersionedData flagWithValue(String key, JsonElement value) {
            JsonElement jsonValue = gson.toJsonTree((Object)value);
            JsonObject o = new JsonObject();
            o.addProperty("key", key);
            o.addProperty("on", Boolean.valueOf(true));
            JsonArray vs = new JsonArray();
            vs.add(jsonValue);
            o.add("variations", (JsonElement)vs);
            JsonObject ft = new JsonObject();
            ft.addProperty("variation", (Number)0);
            o.add("fallthrough", (JsonElement)ft);
            return FlagFactory.flagFromJson((JsonElement)o);
        }

        static VersionedData segmentFromJson(String jsonString) {
            return FlagFactory.segmentFromJson((JsonElement)gson.fromJson(jsonString, JsonElement.class));
        }

        static VersionedData segmentFromJson(JsonElement jsonTree) {
            return (VersionedData)gson.fromJson(jsonTree, VersionedDataKind.SEGMENTS.getItemClass());
        }
    }

    static final class YamlFlagFileParser
    extends FlagFileParser {
        private static final Yaml yaml = new Yaml();
        private static final Gson gson = new Gson();
        private static final JsonFlagFileParser jsonFileParser = new JsonFlagFileParser();

        YamlFlagFileParser() {
        }

        @Override
        public FlagFileRep parse(InputStream input) throws FileDataException, IOException {
            Object root;
            try {
                root = yaml.load(input);
            }
            catch (YAMLException e) {
                throw new FileDataException("unable to parse YAML", e);
            }
            JsonElement jsonRoot = gson.toJsonTree(root);
            return jsonFileParser.parseJson(jsonRoot);
        }
    }

    static final class JsonFlagFileParser
    extends FlagFileParser {
        private static final Gson gson = new Gson();

        JsonFlagFileParser() {
        }

        @Override
        public FlagFileRep parse(InputStream input) throws FileDataException, IOException {
            try {
                return this.parseJson((JsonElement)gson.fromJson((Reader)new InputStreamReader(input), JsonElement.class));
            }
            catch (JsonSyntaxException e) {
                throw new FileDataException("cannot parse JSON", e);
            }
        }

        public FlagFileRep parseJson(JsonElement tree) throws FileDataException, IOException {
            try {
                return (FlagFileRep)gson.fromJson(tree, FlagFileRep.class);
            }
            catch (JsonSyntaxException e) {
                throw new FileDataException("cannot parse JSON", e);
            }
        }
    }

    static abstract class FlagFileParser {
        private static final FlagFileParser jsonParser = new JsonFlagFileParser();
        private static final FlagFileParser yamlParser = new YamlFlagFileParser();

        FlagFileParser() {
        }

        public abstract FlagFileRep parse(InputStream var1) throws FileDataException, IOException;

        public static FlagFileParser selectForContent(byte[] data) {
            InputStreamReader r = new InputStreamReader(new ByteArrayInputStream(data));
            return FlagFileParser.detectJson(r) ? jsonParser : yamlParser;
        }

        private static boolean detectJson(Reader r) {
            try {
                int ch;
                do {
                    if ((ch = r.read()) < 0) {
                        return false;
                    }
                    if (ch != 123) continue;
                    return true;
                } while (Character.isWhitespace(ch));
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    static final class FlagFileRep {
        Map<String, JsonElement> flags;
        Map<String, JsonElement> flagValues;
        Map<String, JsonElement> segments;

        FlagFileRep() {
        }

        FlagFileRep(Map<String, JsonElement> flags, Map<String, JsonElement> flagValues, Map<String, JsonElement> segments) {
            this.flags = flags;
            this.flagValues = flagValues;
            this.segments = segments;
        }
    }

    static final class FileDataException
    extends Exception {
        private final Path filePath;

        public FileDataException(String message, Throwable cause, Path filePath) {
            super(message, cause);
            this.filePath = filePath;
        }

        public FileDataException(String message, Throwable cause) {
            this(message, cause, null);
        }

        public Path getFilePath() {
            return this.filePath;
        }

        public String getDescription() {
            StringBuilder s = new StringBuilder();
            if (this.getMessage() != null) {
                s.append(this.getMessage());
                if (this.getCause() != null) {
                    s.append(" ");
                }
            }
            if (this.getCause() != null) {
                s.append(" [").append(this.getCause().toString()).append("]");
            }
            if (this.filePath != null) {
                s.append(": ").append(this.filePath);
            }
            return s.toString();
        }
    }
}

