/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.DiagnosticAccumulator;
import com.launchdarkly.client.DiagnosticEvent;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.EventFactory;
import com.launchdarkly.client.EventOutputFormatter;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.EventSummarizer;
import com.launchdarkly.client.EventsConfiguration;
import com.launchdarkly.client.JsonHelpers;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.SimpleLRUCache;
import com.launchdarkly.client.interfaces.EventSender;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventProcessor.class);
    @VisibleForTesting
    final EventDispatcher dispatcher;
    private final BlockingQueue<EventProcessorMessage> inbox;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean inputCapacityExceeded = false;

    DefaultEventProcessor(LDConfig config, EventsConfiguration eventsConfig, DiagnosticAccumulator diagnosticAccumulator) {
        this.inbox = new ArrayBlockingQueue<EventProcessorMessage>(eventsConfig.capacity);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-EventProcessor-%d").setPriority(1).build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.dispatcher = new EventDispatcher(config, eventsConfig, this.inbox, threadFactory, this.closed, diagnosticAccumulator);
        Runnable flusher = new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(MessageType.FLUSH, null);
            }
        };
        this.scheduler.scheduleAtFixedRate(flusher, eventsConfig.flushIntervalSeconds, eventsConfig.flushIntervalSeconds, TimeUnit.SECONDS);
        Runnable userKeysFlusher = new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(MessageType.FLUSH_USERS, null);
            }
        };
        this.scheduler.scheduleAtFixedRate(userKeysFlusher, eventsConfig.userKeysFlushIntervalSeconds, eventsConfig.userKeysFlushIntervalSeconds, TimeUnit.SECONDS);
        if (diagnosticAccumulator != null) {
            Runnable diagnosticsTrigger = new Runnable(){

                @Override
                public void run() {
                    DefaultEventProcessor.this.postMessageAsync(MessageType.DIAGNOSTIC, null);
                }
            };
            this.scheduler.scheduleAtFixedRate(diagnosticsTrigger, eventsConfig.diagnosticRecordingIntervalSeconds, eventsConfig.diagnosticRecordingIntervalSeconds, TimeUnit.SECONDS);
        }
    }

    @Override
    public void sendEvent(Event e) {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.EVENT, e);
        }
    }

    @Override
    public void flush() {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.FLUSH, null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduler.shutdown();
            this.postMessageAsync(MessageType.FLUSH, null);
            this.postMessageAndWait(MessageType.SHUTDOWN, null);
        }
    }

    @VisibleForTesting
    void waitUntilInactive() throws IOException {
        this.postMessageAndWait(MessageType.SYNC, null);
    }

    @VisibleForTesting
    void postDiagnostic() {
        this.postMessageAsync(MessageType.DIAGNOSTIC, null);
    }

    private void postMessageAsync(MessageType type, Event event) {
        this.postToChannel(new EventProcessorMessage(type, event, false));
    }

    private void postMessageAndWait(MessageType type, Event event) {
        EventProcessorMessage message = new EventProcessorMessage(type, event, true);
        if (this.postToChannel(message)) {
            message.waitForCompletion();
        }
    }

    private boolean postToChannel(EventProcessorMessage message) {
        if (this.inbox.offer(message)) {
            return true;
        }
        boolean alreadyLogged = this.inputCapacityExceeded;
        this.inputCapacityExceeded = true;
        if (!alreadyLogged) {
            logger.warn("Events are being produced faster than they can be processed; some events will be dropped");
        }
        return false;
    }

    private static final class SendDiagnosticTaskFactory {
        private final EventsConfiguration eventsConfig;

        SendDiagnosticTaskFactory(EventsConfiguration eventsConfig) {
            this.eventsConfig = eventsConfig;
        }

        Runnable createSendDiagnosticTask(final DiagnosticEvent diagnosticEvent) {
            return new Runnable(){

                @Override
                public void run() {
                    String json = JsonHelpers.serialize(diagnosticEvent);
                    ((SendDiagnosticTaskFactory)SendDiagnosticTaskFactory.this).eventsConfig.eventSender.sendEventData(EventSender.EventDataKind.DIAGNOSTICS, json, 1, ((SendDiagnosticTaskFactory)SendDiagnosticTaskFactory.this).eventsConfig.eventsUri);
                }
            };
        }
    }

    private static final class SendEventsTask
    implements Runnable {
        private final EventsConfiguration eventsConfig;
        private final EventResponseListener responseListener;
        private final BlockingQueue<FlushPayload> payloadQueue;
        private final AtomicInteger activeFlushWorkersCount;
        private final AtomicBoolean stopping;
        private final EventOutputFormatter formatter;
        private final Thread thread;

        SendEventsTask(EventsConfiguration eventsConfig, EventResponseListener responseListener, BlockingQueue<FlushPayload> payloadQueue, AtomicInteger activeFlushWorkersCount, ThreadFactory threadFactory) {
            this.eventsConfig = eventsConfig;
            this.formatter = new EventOutputFormatter(eventsConfig);
            this.responseListener = responseListener;
            this.payloadQueue = payloadQueue;
            this.activeFlushWorkersCount = activeFlushWorkersCount;
            this.stopping = new AtomicBoolean(false);
            this.thread = threadFactory.newThread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopping.get()) {
                FlushPayload payload = null;
                try {
                    payload = this.payloadQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    StringWriter stringWriter = new StringWriter();
                    int outputEventCount = this.formatter.writeOutputEvents(payload.events, payload.summary, stringWriter);
                    if (outputEventCount > 0) {
                        EventSender.Result result = this.eventsConfig.eventSender.sendEventData(EventSender.EventDataKind.ANALYTICS, stringWriter.toString(), outputEventCount, this.eventsConfig.eventsUri);
                        this.responseListener.handleResponse(result);
                    }
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                }
                AtomicInteger atomicInteger = this.activeFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.activeFlushWorkersCount.decrementAndGet();
                    this.activeFlushWorkersCount.notifyAll();
                }
            }
        }

        void stop() {
            this.stopping.set(true);
            this.thread.interrupt();
        }
    }

    private static interface EventResponseListener {
        public void handleResponse(EventSender.Result var1);
    }

    private static final class FlushPayload {
        final Event[] events;
        final EventSummarizer.EventSummary summary;

        FlushPayload(Event[] events, EventSummarizer.EventSummary summary) {
            this.events = events;
            this.summary = summary;
        }
    }

    private static final class EventBuffer {
        final List<Event> events = new ArrayList<Event>();
        final EventSummarizer summarizer = new EventSummarizer();
        private final int capacity;
        private boolean capacityExceeded = false;
        private long droppedEventCount = 0L;

        EventBuffer(int capacity) {
            this.capacity = capacity;
        }

        void add(Event e) {
            if (this.events.size() >= this.capacity) {
                if (!this.capacityExceeded) {
                    this.capacityExceeded = true;
                    logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
                }
                ++this.droppedEventCount;
            } else {
                this.capacityExceeded = false;
                this.events.add(e);
            }
        }

        void addToSummary(Event e) {
            this.summarizer.summarizeEvent(e);
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.summarizer.snapshot().isEmpty();
        }

        long getAndClearDroppedCount() {
            long res = this.droppedEventCount;
            this.droppedEventCount = 0L;
            return res;
        }

        FlushPayload getPayload() {
            Event[] eventsOut = this.events.toArray(new Event[this.events.size()]);
            EventSummarizer.EventSummary summary = this.summarizer.snapshot();
            return new FlushPayload(eventsOut, summary);
        }

        void clear() {
            this.events.clear();
            this.summarizer.clear();
        }
    }

    static final class EventDispatcher {
        private static final int MAX_FLUSH_THREADS = 5;
        private static final int MESSAGE_BATCH_SIZE = 50;
        @VisibleForTesting
        final EventsConfiguration eventsConfig;
        private final List<SendEventsTask> flushWorkers;
        private final AtomicInteger busyFlushWorkersCount;
        private final Random random = new Random();
        private final AtomicLong lastKnownPastTime = new AtomicLong(0L);
        private final AtomicBoolean disabled = new AtomicBoolean(false);
        private final DiagnosticAccumulator diagnosticAccumulator;
        private final ExecutorService diagnosticExecutor;
        private final SendDiagnosticTaskFactory sendDiagnosticTaskFactory;
        private long deduplicatedUsers = 0L;

        private EventDispatcher(LDConfig config, EventsConfiguration eventsConfig, final BlockingQueue<EventProcessorMessage> inbox, ThreadFactory threadFactory, final AtomicBoolean closed, DiagnosticAccumulator diagnosticAccumulator) {
            this.eventsConfig = eventsConfig;
            this.diagnosticAccumulator = diagnosticAccumulator;
            this.busyFlushWorkersCount = new AtomicInteger(0);
            final ArrayBlockingQueue<FlushPayload> payloadQueue = new ArrayBlockingQueue<FlushPayload>(1);
            final EventBuffer outbox = new EventBuffer(eventsConfig.capacity);
            final SimpleLRUCache userKeys = new SimpleLRUCache(eventsConfig.userKeysCapacity);
            Thread mainThread = threadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    EventDispatcher.this.runMainLoop(inbox, outbox, userKeys, payloadQueue);
                }
            });
            mainThread.setDaemon(true);
            mainThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    logger.error("Event processor thread was terminated by an unrecoverable error. No more analytics events will be sent.", e);
                    closed.set(true);
                    ArrayList messages = new ArrayList();
                    inbox.drainTo(messages);
                    for (EventProcessorMessage m : messages) {
                        m.completed();
                    }
                }
            });
            mainThread.start();
            this.flushWorkers = new ArrayList<SendEventsTask>();
            EventResponseListener listener = new EventResponseListener(){

                @Override
                public void handleResponse(EventSender.Result result) {
                    EventDispatcher.this.handleResponse(result);
                }
            };
            for (int i = 0; i < 5; ++i) {
                SendEventsTask task = new SendEventsTask(eventsConfig, listener, payloadQueue, this.busyFlushWorkersCount, threadFactory);
                this.flushWorkers.add(task);
            }
            if (diagnosticAccumulator != null) {
                this.sendDiagnosticTaskFactory = new SendDiagnosticTaskFactory(eventsConfig);
                this.diagnosticExecutor = Executors.newSingleThreadExecutor(threadFactory);
                DiagnosticEvent.Init diagnosticInitEvent = new DiagnosticEvent.Init(diagnosticAccumulator.dataSinceDate, diagnosticAccumulator.diagnosticId, config);
                this.diagnosticExecutor.submit(this.sendDiagnosticTaskFactory.createSendDiagnosticTask(diagnosticInitEvent));
            } else {
                this.diagnosticExecutor = null;
                this.sendDiagnosticTaskFactory = null;
            }
        }

        private void runMainLoop(BlockingQueue<EventProcessorMessage> inbox, EventBuffer outbox, SimpleLRUCache<String, String> userKeys, BlockingQueue<FlushPayload> payloadQueue) {
            ArrayList<EventProcessorMessage> batch = new ArrayList<EventProcessorMessage>(50);
            while (true) {
                try {
                    block12: while (true) {
                        batch.clear();
                        batch.add(inbox.take());
                        inbox.drainTo(batch, 49);
                        Iterator iterator = batch.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block12;
                            EventProcessorMessage message = (EventProcessorMessage)iterator.next();
                            switch (message.type) {
                                case EVENT: {
                                    this.processEvent(message.event, userKeys, outbox);
                                    break;
                                }
                                case FLUSH: {
                                    this.triggerFlush(outbox, payloadQueue);
                                    break;
                                }
                                case FLUSH_USERS: {
                                    userKeys.clear();
                                    break;
                                }
                                case DIAGNOSTIC: {
                                    this.sendAndResetDiagnostics(outbox);
                                    break;
                                }
                                case SYNC: {
                                    this.waitUntilAllFlushWorkersInactive();
                                    break;
                                }
                                case SHUTDOWN: {
                                    this.doShutdown();
                                    message.completed();
                                    return;
                                }
                            }
                            message.completed();
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void sendAndResetDiagnostics(EventBuffer outbox) {
            long droppedEvents = outbox.getAndClearDroppedCount();
            DiagnosticEvent.Statistics diagnosticEvent = this.diagnosticAccumulator.createEventAndReset(droppedEvents, this.deduplicatedUsers);
            this.deduplicatedUsers = 0L;
            this.diagnosticExecutor.submit(this.sendDiagnosticTaskFactory.createSendDiagnosticTask(diagnosticEvent));
        }

        private void doShutdown() {
            this.waitUntilAllFlushWorkersInactive();
            this.disabled.set(true);
            for (SendEventsTask task : this.flushWorkers) {
                task.stop();
            }
            if (this.diagnosticExecutor != null) {
                this.diagnosticExecutor.shutdown();
            }
            try {
                this.eventsConfig.eventSender.close();
            }
            catch (IOException e) {
                logger.error("Unexpected error when closing event sender: {}", (Object)e.toString());
                logger.debug(e.toString(), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitUntilAllFlushWorkersInactive() {
            while (true) {
                try {
                    while (true) {
                        AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                        synchronized (atomicInteger) {
                            if (this.busyFlushWorkersCount.get() == 0) {
                                return;
                            }
                            this.busyFlushWorkersCount.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void processEvent(Event e, SimpleLRUCache<String, String> userKeys, EventBuffer outbox) {
            if (this.disabled.get()) {
                return;
            }
            outbox.addToSummary(e);
            boolean addIndexEvent = false;
            boolean addFullEvent = false;
            Event.FeatureRequest debugEvent = null;
            if (e instanceof Event.FeatureRequest) {
                if (this.shouldSampleEvent()) {
                    Event.FeatureRequest fe = (Event.FeatureRequest)e;
                    addFullEvent = fe.trackEvents;
                    if (this.shouldDebugEvent(fe)) {
                        debugEvent = EventFactory.DEFAULT.newDebugEvent(fe);
                    }
                }
            } else {
                addFullEvent = this.shouldSampleEvent();
            }
            if (!(addFullEvent && this.eventsConfig.inlineUsersInEvents || e.user == null || e.user.getKey() == null)) {
                boolean isIndexEvent = e instanceof Event.Identify;
                boolean alreadySeen = this.noticeUser(e.user, userKeys);
                addIndexEvent = !isIndexEvent & !alreadySeen;
                if (!isIndexEvent & alreadySeen) {
                    ++this.deduplicatedUsers;
                }
            }
            if (addIndexEvent) {
                Event.Index ie = new Event.Index(e.creationDate, e.user);
                outbox.add(ie);
            }
            if (addFullEvent) {
                outbox.add(e);
            }
            if (debugEvent != null) {
                outbox.add(debugEvent);
            }
        }

        private boolean noticeUser(LDUser user, SimpleLRUCache<String, String> userKeys) {
            if (user == null || user.getKey() == null) {
                return false;
            }
            String key = user.getKeyAsString();
            return userKeys.put(key, key) != null;
        }

        private boolean shouldSampleEvent() {
            return this.eventsConfig.samplingInterval <= 0 || this.random.nextInt(this.eventsConfig.samplingInterval) == 0;
        }

        private boolean shouldDebugEvent(Event.FeatureRequest fe) {
            if (fe.debugEventsUntilDate != null) {
                long lastPast = this.lastKnownPastTime.get();
                if (fe.debugEventsUntilDate > lastPast && fe.debugEventsUntilDate > System.currentTimeMillis()) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerFlush(EventBuffer outbox, BlockingQueue<FlushPayload> payloadQueue) {
            if (this.disabled.get() || outbox.isEmpty()) {
                return;
            }
            FlushPayload payload = outbox.getPayload();
            if (this.diagnosticAccumulator != null) {
                this.diagnosticAccumulator.recordEventsInBatch(payload.events.length);
            }
            this.busyFlushWorkersCount.incrementAndGet();
            if (payloadQueue.offer(payload)) {
                outbox.clear();
            } else {
                logger.debug("Skipped flushing because all workers are busy");
                AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.busyFlushWorkersCount.decrementAndGet();
                    this.busyFlushWorkersCount.notify();
                }
            }
        }

        private void handleResponse(EventSender.Result result) {
            if (result.getTimeFromServer() != null) {
                this.lastKnownPastTime.set(result.getTimeFromServer().getTime());
            }
            if (result.isMustShutDown()) {
                this.disabled.set(true);
            }
        }
    }

    private static final class EventProcessorMessage {
        private final MessageType type;
        private final Event event;
        private final Semaphore reply;

        private EventProcessorMessage(MessageType type, Event event, boolean sync) {
            this.type = type;
            this.event = event;
            this.reply = sync ? new Semaphore(0) : null;
        }

        void completed() {
            if (this.reply != null) {
                this.reply.release();
            }
        }

        void waitForCompletion() {
            if (this.reply == null) {
                return;
            }
            while (true) {
                try {
                    this.reply.acquire();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public String toString() {
            return (this.event == null ? this.type.toString() : (Object)((Object)this.type) + ": " + this.event.getClass().getSimpleName()) + (this.reply == null ? "" : " (sync)");
        }
    }

    private static enum MessageType {
        EVENT,
        FLUSH,
        FLUSH_USERS,
        DIAGNOSTIC,
        SYNC,
        SHUTDOWN;

    }
}

