/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.SegmentRule;
import com.launchdarkly.client.VersionedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class Segment
implements VersionedData {
    private String key;
    private Set<String> included;
    private Set<String> excluded;
    private String salt;
    private List<SegmentRule> rules;
    private int version;
    private boolean deleted;

    Segment() {
    }

    private Segment(Builder builder) {
        this.key = builder.key;
        this.included = builder.included;
        this.excluded = builder.excluded;
        this.salt = builder.salt;
        this.rules = builder.rules;
        this.version = builder.version;
        this.deleted = builder.deleted;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public Iterable<String> getIncluded() {
        return this.included;
    }

    public Iterable<String> getExcluded() {
        return this.excluded;
    }

    public String getSalt() {
        return this.salt;
    }

    public Iterable<SegmentRule> getRules() {
        return this.rules;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean matchesUser(LDUser user) {
        String key = user.getKeyAsString();
        if (key == null) {
            return false;
        }
        if (this.included.contains(key)) {
            return true;
        }
        if (this.excluded.contains(key)) {
            return false;
        }
        for (SegmentRule rule : this.rules) {
            if (!rule.matchUser(user, key, this.salt)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private String key;
        private Set<String> included = new HashSet<String>();
        private Set<String> excluded = new HashSet<String>();
        private String salt = "";
        private List<SegmentRule> rules = new ArrayList<SegmentRule>();
        private int version = 0;
        private boolean deleted;

        public Builder(String key) {
            this.key = key;
        }

        public Builder(Segment from) {
            this.key = from.key;
            this.included = new HashSet<String>(from.included);
            this.excluded = new HashSet<String>(from.excluded);
            this.salt = from.salt;
            this.rules = new ArrayList<SegmentRule>(from.rules);
            this.version = from.version;
            this.deleted = from.deleted;
        }

        public Segment build() {
            return new Segment(this);
        }

        public Builder included(Collection<String> included) {
            this.included = new HashSet<String>(included);
            return this;
        }

        public Builder excluded(Collection<String> excluded) {
            this.excluded = new HashSet<String>(excluded);
            return this;
        }

        public Builder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public Builder rules(Collection<SegmentRule> rules) {
            this.rules = new ArrayList<SegmentRule>(rules);
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }
    }
}

