/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import java.util.Objects;

public abstract class EvaluationReason {
    private final Kind kind;

    public Kind getKind() {
        return this.kind;
    }

    public String toString() {
        return this.getKind().name();
    }

    protected EvaluationReason(Kind kind) {
        this.kind = kind;
    }

    public static Off off() {
        return Off.instance;
    }

    public static TargetMatch targetMatch() {
        return TargetMatch.instance;
    }

    public static RuleMatch ruleMatch(int ruleIndex, String ruleId) {
        return new RuleMatch(ruleIndex, ruleId);
    }

    public static PrerequisiteFailed prerequisiteFailed(String prerequisiteKey) {
        return new PrerequisiteFailed(prerequisiteKey);
    }

    public static Fallthrough fallthrough() {
        return Fallthrough.instance;
    }

    public static Error error(ErrorKind errorKind) {
        return new Error(errorKind);
    }

    public static class Error
    extends EvaluationReason {
        private final ErrorKind errorKind;

        private Error(ErrorKind errorKind) {
            super(Kind.ERROR);
            Preconditions.checkNotNull(errorKind);
            this.errorKind = errorKind;
        }

        public ErrorKind getErrorKind() {
            return this.errorKind;
        }

        public boolean equals(Object other) {
            return other instanceof Error && this.errorKind == ((Error)other).errorKind;
        }

        public int hashCode() {
            return this.errorKind.hashCode();
        }

        @Override
        public String toString() {
            return this.getKind().name() + "(" + this.errorKind.name() + ")";
        }
    }

    public static class Fallthrough
    extends EvaluationReason {
        private static final Fallthrough instance = new Fallthrough();

        private Fallthrough() {
            super(Kind.FALLTHROUGH);
        }
    }

    public static class PrerequisiteFailed
    extends EvaluationReason {
        private final String prerequisiteKey;

        private PrerequisiteFailed(String prerequisiteKey) {
            super(Kind.PREREQUISITE_FAILED);
            this.prerequisiteKey = Preconditions.checkNotNull(prerequisiteKey);
        }

        public String getPrerequisiteKey() {
            return this.prerequisiteKey;
        }

        public boolean equals(Object other) {
            return other instanceof PrerequisiteFailed && ((PrerequisiteFailed)other).prerequisiteKey.equals(this.prerequisiteKey);
        }

        public int hashCode() {
            return this.prerequisiteKey.hashCode();
        }

        @Override
        public String toString() {
            return this.getKind().name() + "(" + this.prerequisiteKey + ")";
        }
    }

    public static class RuleMatch
    extends EvaluationReason {
        private final int ruleIndex;
        private final String ruleId;

        private RuleMatch(int ruleIndex, String ruleId) {
            super(Kind.RULE_MATCH);
            this.ruleIndex = ruleIndex;
            this.ruleId = ruleId;
        }

        public int getRuleIndex() {
            return this.ruleIndex;
        }

        public String getRuleId() {
            return this.ruleId;
        }

        public boolean equals(Object other) {
            if (other instanceof RuleMatch) {
                RuleMatch o = (RuleMatch)other;
                return this.ruleIndex == o.ruleIndex && Objects.equals(this.ruleId, o.ruleId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.ruleIndex, this.ruleId);
        }

        @Override
        public String toString() {
            return this.getKind().name() + "(" + this.ruleIndex + (this.ruleId == null ? "" : "," + this.ruleId) + ")";
        }
    }

    public static class TargetMatch
    extends EvaluationReason {
        private static final TargetMatch instance = new TargetMatch();

        private TargetMatch() {
            super(Kind.TARGET_MATCH);
        }
    }

    public static class Off
    extends EvaluationReason {
        private static final Off instance = new Off();

        private Off() {
            super(Kind.OFF);
        }
    }

    public static enum ErrorKind {
        CLIENT_NOT_READY,
        FLAG_NOT_FOUND,
        MALFORMED_FLAG,
        USER_NOT_SPECIFIED,
        WRONG_TYPE,
        EXCEPTION;

    }

    public static enum Kind {
        OFF,
        FALLTHROUGH,
        TARGET_MATCH,
        RULE_MATCH,
        PREREQUISITE_FAILED,
        ERROR;

    }
}

