/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.EvaluationDetail;
import com.launchdarkly.client.EvaluationReason;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.EventFactory;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.Prerequisite;
import com.launchdarkly.client.Rule;
import com.launchdarkly.client.Target;
import com.launchdarkly.client.VariationOrRollout;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureFlag
implements VersionedData {
    private static final Logger logger = LoggerFactory.getLogger(FeatureFlag.class);
    private String key;
    private int version;
    private boolean on;
    private List<Prerequisite> prerequisites;
    private String salt;
    private List<Target> targets;
    private List<Rule> rules;
    private VariationOrRollout fallthrough;
    private Integer offVariation;
    private List<JsonElement> variations;
    private boolean clientSide;
    private boolean trackEvents;
    private boolean trackEventsFallthrough;
    private Long debugEventsUntilDate;
    private boolean deleted;

    FeatureFlag() {
    }

    FeatureFlag(String key, int version, boolean on, List<Prerequisite> prerequisites, String salt, List<Target> targets, List<Rule> rules, VariationOrRollout fallthrough, Integer offVariation, List<JsonElement> variations, boolean clientSide, boolean trackEvents, boolean trackEventsFallthrough, Long debugEventsUntilDate, boolean deleted) {
        this.key = key;
        this.version = version;
        this.on = on;
        this.prerequisites = prerequisites;
        this.salt = salt;
        this.targets = targets;
        this.rules = rules;
        this.fallthrough = fallthrough;
        this.offVariation = offVariation;
        this.variations = variations;
        this.clientSide = clientSide;
        this.trackEvents = trackEvents;
        this.trackEventsFallthrough = trackEventsFallthrough;
        this.debugEventsUntilDate = debugEventsUntilDate;
        this.deleted = deleted;
    }

    EvalResult evaluate(LDUser user, FeatureStore featureStore, EventFactory eventFactory) {
        ArrayList<Event.FeatureRequest> prereqEvents = new ArrayList<Event.FeatureRequest>();
        if (user == null || user.getKey() == null) {
            logger.warn("Null user or null user key when evaluating flag \"{}\"; returning null", (Object)this.key);
            return new EvalResult(EvaluationDetail.error(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED, null), prereqEvents);
        }
        EvaluationDetail<JsonElement> details = this.evaluate(user, featureStore, prereqEvents, eventFactory);
        return new EvalResult(details, prereqEvents);
    }

    private EvaluationDetail<JsonElement> evaluate(LDUser user, FeatureStore featureStore, List<Event.FeatureRequest> events, EventFactory eventFactory) {
        if (!this.isOn()) {
            return this.getOffValue(EvaluationReason.off());
        }
        EvaluationReason prereqFailureReason = this.checkPrerequisites(user, featureStore, events, eventFactory);
        if (prereqFailureReason != null) {
            return this.getOffValue(prereqFailureReason);
        }
        if (this.targets != null) {
            for (Target target : this.targets) {
                for (String v : target.getValues()) {
                    if (!v.equals(user.getKey().getAsString())) continue;
                    return this.getVariation(target.getVariation(), EvaluationReason.targetMatch());
                }
            }
        }
        if (this.rules != null) {
            for (int i = 0; i < this.rules.size(); ++i) {
                Rule rule = this.rules.get(i);
                if (!rule.matchesUser(featureStore, user)) continue;
                return this.getValueForVariationOrRollout(rule, user, EvaluationReason.ruleMatch(i, rule.getId()));
            }
        }
        return this.getValueForVariationOrRollout(this.fallthrough, user, EvaluationReason.fallthrough());
    }

    private EvaluationReason checkPrerequisites(LDUser user, FeatureStore featureStore, List<Event.FeatureRequest> events, EventFactory eventFactory) {
        if (this.prerequisites == null) {
            return null;
        }
        for (int i = 0; i < this.prerequisites.size(); ++i) {
            boolean prereqOk = true;
            Prerequisite prereq = this.prerequisites.get(i);
            FeatureFlag prereqFeatureFlag = featureStore.get(VersionedDataKind.FEATURES, prereq.getKey());
            if (prereqFeatureFlag == null) {
                logger.error("Could not retrieve prerequisite flag \"{}\" when evaluating \"{}\"", (Object)prereq.getKey(), (Object)this.key);
                prereqOk = false;
            } else {
                EvaluationDetail<JsonElement> prereqEvalResult = prereqFeatureFlag.evaluate(user, featureStore, events, eventFactory);
                if (!prereqFeatureFlag.isOn() || prereqEvalResult == null || prereqEvalResult.getVariationIndex().intValue() != prereq.getVariation()) {
                    prereqOk = false;
                }
                events.add(eventFactory.newPrerequisiteFeatureRequestEvent(prereqFeatureFlag, user, prereqEvalResult, this));
            }
            if (prereqOk) continue;
            return EvaluationReason.prerequisiteFailed(prereq.getKey());
        }
        return null;
    }

    private EvaluationDetail<JsonElement> getVariation(int variation, EvaluationReason reason) {
        if (variation < 0 || variation >= this.variations.size()) {
            logger.error("Data inconsistency in feature flag \"{}\": invalid variation index", (Object)this.key);
            return EvaluationDetail.error(EvaluationReason.ErrorKind.MALFORMED_FLAG, null);
        }
        return new EvaluationDetail<JsonElement>(reason, variation, this.variations.get(variation));
    }

    private EvaluationDetail<JsonElement> getOffValue(EvaluationReason reason) {
        if (this.offVariation == null) {
            return new EvaluationDetail<Object>(reason, null, null);
        }
        return this.getVariation(this.offVariation, reason);
    }

    private EvaluationDetail<JsonElement> getValueForVariationOrRollout(VariationOrRollout vr, LDUser user, EvaluationReason reason) {
        Integer index = vr.variationIndexForUser(user, this.key, this.salt);
        if (index == null) {
            logger.error("Data inconsistency in feature flag \"{}\": variation/rollout object with no variation or rollout", (Object)this.key);
            return EvaluationDetail.error(EvaluationReason.ErrorKind.MALFORMED_FLAG, null);
        }
        return this.getVariation(index, reason);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public boolean isTrackEvents() {
        return this.trackEvents;
    }

    public boolean isTrackEventsFallthrough() {
        return this.trackEventsFallthrough;
    }

    public Long getDebugEventsUntilDate() {
        return this.debugEventsUntilDate;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    boolean isOn() {
        return this.on;
    }

    List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    String getSalt() {
        return this.salt;
    }

    List<Target> getTargets() {
        return this.targets;
    }

    List<Rule> getRules() {
        return this.rules;
    }

    VariationOrRollout getFallthrough() {
        return this.fallthrough;
    }

    List<JsonElement> getVariations() {
        return this.variations;
    }

    Integer getOffVariation() {
        return this.offVariation;
    }

    boolean isClientSide() {
        return this.clientSide;
    }

    static class EvalResult {
        private final EvaluationDetail<JsonElement> details;
        private final List<Event.FeatureRequest> prerequisiteEvents;

        private EvalResult(EvaluationDetail<JsonElement> details, List<Event.FeatureRequest> prerequisiteEvents) {
            Preconditions.checkNotNull(details);
            Preconditions.checkNotNull(prerequisiteEvents);
            this.details = details;
            this.prerequisiteEvents = prerequisiteEvents;
        }

        EvaluationDetail<JsonElement> getDetails() {
            return this.details;
        }

        List<Event.FeatureRequest> getPrerequisiteEvents() {
            return this.prerequisiteEvents;
        }
    }
}

