/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Clause;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.VariationOrRollout;
import java.util.List;

class Rule
extends VariationOrRollout {
    private String id;
    private List<Clause> clauses;
    private boolean trackEvents;

    Rule() {
    }

    Rule(String id, List<Clause> clauses, Integer variation, VariationOrRollout.Rollout rollout, boolean trackEvents) {
        super(variation, rollout);
        this.id = id;
        this.clauses = clauses;
        this.trackEvents = trackEvents;
    }

    Rule(String id, List<Clause> clauses, Integer variation, VariationOrRollout.Rollout rollout) {
        this(id, clauses, variation, rollout, false);
    }

    String getId() {
        return this.id;
    }

    Iterable<Clause> getClauses() {
        return this.clauses;
    }

    boolean isTrackEvents() {
        return this.trackEvents;
    }

    boolean matchesUser(FeatureStore store, LDUser user) {
        for (Clause clause : this.clauses) {
            if (clause.matchesUser(store, user)) continue;
            return false;
        }
        return true;
    }
}

