/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonPrimitive;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.org.joda.time.DateTime;
import com.launchdarkly.shaded.org.joda.time.DateTimeZone;
import java.util.concurrent.TimeUnit;

class Util {
    Util() {
    }

    static DateTime jsonPrimitiveToDateTime(JsonPrimitive maybeDate) {
        if (maybeDate.isNumber()) {
            long millis = maybeDate.getAsLong();
            return new DateTime(millis);
        }
        if (maybeDate.isString()) {
            try {
                return new DateTime((Object)maybeDate.getAsString(), DateTimeZone.UTC);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    static void configureHttpClientBuilder(LDConfig config, OkHttpClient.Builder builder) {
        builder.connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(config.connectTimeout, config.connectTimeoutUnit).readTimeout(config.socketTimeout, config.socketTimeoutUnit).writeTimeout(config.socketTimeout, config.socketTimeoutUnit).retryOnConnectionFailure(false);
        if (config.sslSocketFactory != null) {
            builder.sslSocketFactory(config.sslSocketFactory, config.trustManager);
        }
        if (config.proxy != null) {
            builder.proxy(config.proxy);
            if (config.proxyAuthenticator != null) {
                builder.proxyAuthenticator(config.proxyAuthenticator);
            }
        }
    }

    static Request.Builder getRequestBuilder(String sdkKey) {
        return new Request.Builder().addHeader("Authorization", sdkKey).addHeader("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
    }

    static void shutdownHttpClient(OkHttpClient client) {
        if (client.dispatcher() != null) {
            client.dispatcher().cancelAll();
            if (client.dispatcher().executorService() != null) {
                client.dispatcher().executorService().shutdown();
            }
        }
        if (client.connectionPool() != null) {
            client.connectionPool().evictAll();
        }
        if (client.cache() != null) {
            try {
                client.cache().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isHttpErrorRecoverable(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 400: 
                case 408: 
                case 429: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    static String httpErrorMessage(int statusCode, String context, String recoverableMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("Received HTTP error ").append(statusCode);
        switch (statusCode) {
            case 401: 
            case 403: {
                sb.append(" (invalid SDK key)");
            }
        }
        sb.append(" for ").append(context).append(" - ");
        sb.append(Util.isHttpErrorRecoverable(statusCode) ? recoverableMessage : "giving up permanently");
        return sb.toString();
    }
}

