/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.Operator;
import com.launchdarkly.client.Segment;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.client.value.LDValueType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Clause {
    private static final Logger logger = LoggerFactory.getLogger(Clause.class);
    private String attribute;
    private Operator op;
    private List<LDValue> values;
    private boolean negate;

    public Clause() {
    }

    public Clause(String attribute, Operator op, List<LDValue> values, boolean negate) {
        this.attribute = attribute;
        this.op = op;
        this.values = values;
        this.negate = negate;
    }

    boolean matchesUserNoSegments(LDUser user) {
        LDValue userValue = user.getValueForEvaluation(this.attribute);
        if (userValue.isNull()) {
            return false;
        }
        if (userValue.getType() == LDValueType.ARRAY) {
            for (LDValue value : userValue.values()) {
                if (value.getType() == LDValueType.ARRAY || value.getType() == LDValueType.OBJECT) {
                    logger.error("Invalid custom attribute value in user object for user key \"{}\": {}", (Object)user.getKey(), (Object)value);
                    return false;
                }
                if (!this.matchAny(value)) continue;
                return this.maybeNegate(true);
            }
            return this.maybeNegate(false);
        }
        if (userValue.getType() != LDValueType.OBJECT) {
            return this.maybeNegate(this.matchAny(userValue));
        }
        logger.warn("Got unexpected user attribute type \"{}\" for user key \"{}\" and attribute \"{}\"", new Object[]{userValue.getType(), user.getKey(), this.attribute});
        return false;
    }

    boolean matchesUser(FeatureStore store, LDUser user) {
        if (this.op == Operator.segmentMatch) {
            for (LDValue j : this.values) {
                Segment segment;
                if (!j.isString() || (segment = store.get(VersionedDataKind.SEGMENTS, j.stringValue())) == null || !segment.matchesUser(user)) continue;
                return this.maybeNegate(true);
            }
            return this.maybeNegate(false);
        }
        return this.matchesUserNoSegments(user);
    }

    private boolean matchAny(LDValue userValue) {
        if (this.op != null) {
            for (LDValue v : this.values) {
                if (!this.op.apply(userValue, v)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean maybeNegate(boolean b) {
        if (this.negate) {
            return !b;
        }
        return b;
    }
}

