/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.DefaultEventProcessor;
import com.launchdarkly.client.DefaultFeatureRequestor;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.EventProcessorFactory;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.InMemoryFeatureStore;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.PollingProcessor;
import com.launchdarkly.client.RedisFeatureStoreBuilder;
import com.launchdarkly.client.StreamProcessor;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.UpdateProcessorFactory;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Components {
    private static final FeatureStoreFactory inMemoryFeatureStoreFactory = new InMemoryFeatureStoreFactory();
    private static final EventProcessorFactory defaultEventProcessorFactory = new DefaultEventProcessorFactory();
    private static final EventProcessorFactory nullEventProcessorFactory = new NullEventProcessorFactory();
    private static final UpdateProcessorFactory defaultUpdateProcessorFactory = new DefaultUpdateProcessorFactory();
    private static final UpdateProcessorFactory nullUpdateProcessorFactory = new NullUpdateProcessorFactory();

    public static FeatureStoreFactory inMemoryFeatureStore() {
        return inMemoryFeatureStoreFactory;
    }

    public static RedisFeatureStoreBuilder redisFeatureStore() {
        return new RedisFeatureStoreBuilder();
    }

    public static RedisFeatureStoreBuilder redisFeatureStore(URI redisUri) {
        return new RedisFeatureStoreBuilder(redisUri);
    }

    public static EventProcessorFactory defaultEventProcessor() {
        return defaultEventProcessorFactory;
    }

    public static EventProcessorFactory nullEventProcessor() {
        return nullEventProcessorFactory;
    }

    public static UpdateProcessorFactory defaultUpdateProcessor() {
        return defaultUpdateProcessorFactory;
    }

    public static UpdateProcessorFactory nullUpdateProcessor() {
        return nullUpdateProcessorFactory;
    }

    private static final class NullUpdateProcessorFactory
    implements UpdateProcessorFactory {
        private NullUpdateProcessorFactory() {
        }

        @Override
        public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore) {
            return new UpdateProcessor.NullUpdateProcessor();
        }
    }

    private static final class DefaultUpdateProcessorFactory
    implements UpdateProcessorFactory {
        private static final Logger logger = LoggerFactory.getLogger(LDClient.class);

        private DefaultUpdateProcessorFactory() {
        }

        @Override
        public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore) {
            if (config.offline) {
                logger.info("Starting LaunchDarkly client in offline mode");
                return new UpdateProcessor.NullUpdateProcessor();
            }
            if (config.useLdd) {
                logger.info("Starting LaunchDarkly in LDD mode. Skipping direct feature retrieval.");
                return new UpdateProcessor.NullUpdateProcessor();
            }
            DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(sdkKey, config);
            if (config.stream) {
                logger.info("Enabling streaming API");
                return new StreamProcessor(sdkKey, config, requestor, featureStore, null);
            }
            logger.info("Disabling streaming API");
            logger.warn("You should only disable the streaming API if instructed to do so by LaunchDarkly support");
            return new PollingProcessor(config, requestor, featureStore);
        }
    }

    private static final class NullEventProcessorFactory
    implements EventProcessorFactory {
        private NullEventProcessorFactory() {
        }

        @Override
        public EventProcessor createEventProcessor(String sdkKey, LDConfig config) {
            return new EventProcessor.NullEventProcessor();
        }
    }

    private static final class DefaultEventProcessorFactory
    implements EventProcessorFactory {
        private DefaultEventProcessorFactory() {
        }

        @Override
        public EventProcessor createEventProcessor(String sdkKey, LDConfig config) {
            if (config.offline || !config.sendEvents) {
                return new EventProcessor.NullEventProcessor();
            }
            return new DefaultEventProcessor(sdkKey, config);
        }
    }

    private static final class InMemoryFeatureStoreFactory
    implements FeatureStoreFactory {
        private InMemoryFeatureStoreFactory() {
        }

        @Override
        public FeatureStore createFeatureStore() {
            return new InMemoryFeatureStore();
        }
    }
}

