/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.files;

import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.files.DataBuilder;
import com.launchdarkly.client.files.DataLoader;
import com.launchdarkly.client.files.DataLoaderException;
import com.launchdarkly.shaded.com.google.common.util.concurrent.Futures;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileDataSource
implements UpdateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FileDataSource.class);
    private final FeatureStore store;
    private final DataLoader dataLoader;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final FileWatcher fileWatcher;

    FileDataSource(FeatureStore store, DataLoader dataLoader, boolean autoUpdate) {
        this.store = store;
        this.dataLoader = dataLoader;
        FileWatcher fw = null;
        if (autoUpdate) {
            try {
                fw = FileWatcher.create(dataLoader.getFiles());
            }
            catch (IOException e) {
                logger.error("Unable to watch files for auto-updating: " + e);
                fw = null;
            }
        }
        this.fileWatcher = fw;
    }

    @Override
    public Future<Void> start() {
        ListenableFuture<Object> initFuture = Futures.immediateFuture(null);
        this.reload();
        if (this.fileWatcher != null) {
            this.fileWatcher.start(new Runnable(){

                @Override
                public void run() {
                    FileDataSource.this.reload();
                }
            });
        }
        return initFuture;
    }

    private boolean reload() {
        DataBuilder builder = new DataBuilder();
        try {
            this.dataLoader.load(builder);
        }
        catch (DataLoaderException e) {
            logger.error(e.getDescription());
            return false;
        }
        this.store.init(builder.build());
        this.inited.set(true);
        return true;
    }

    @Override
    public boolean initialized() {
        return this.inited.get();
    }

    @Override
    public void close() throws IOException {
        if (this.fileWatcher != null) {
            this.fileWatcher.stop();
        }
    }

    private static class FileWatcher
    implements Runnable {
        private final WatchService watchService;
        private final Set<Path> watchedFilePaths;
        private Runnable fileModifiedAction;
        private Thread thread;
        private volatile boolean stopped;

        private static FileWatcher create(Iterable<Path> files) throws IOException {
            HashSet<Path> directoryPaths = new HashSet<Path>();
            HashSet<Path> absoluteFilePaths = new HashSet<Path>();
            FileSystem fs = FileSystems.getDefault();
            WatchService ws = fs.newWatchService();
            for (Path p : files) {
                absoluteFilePaths.add(p);
                directoryPaths.add(p.getParent());
            }
            for (Path d : directoryPaths) {
                d.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
            return new FileWatcher(ws, absoluteFilePaths);
        }

        private FileWatcher(WatchService watchService, Set<Path> watchedFilePaths) {
            this.watchService = watchService;
            this.watchedFilePaths = watchedFilePaths;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    WatchKey key = this.watchService.take();
                    boolean watchedFileWasChanged = false;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path fileNamePath;
                        Path dirPath;
                        Path absolutePath;
                        Watchable w = key.watchable();
                        Object context = event.context();
                        if (!(w instanceof Path) || !(context instanceof Path) || !this.watchedFilePaths.contains(absolutePath = (dirPath = (Path)w).resolve(fileNamePath = (Path)context))) continue;
                        watchedFileWasChanged = true;
                        break;
                    }
                    if (watchedFileWasChanged) {
                        try {
                            this.fileModifiedAction.run();
                        }
                        catch (Exception e) {
                            logger.warn("Unexpected exception when reloading file data: " + e);
                        }
                    }
                    key.reset();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void start(Runnable fileModifiedAction) {
            this.fileModifiedAction = fileModifiedAction;
            this.thread = new Thread((Runnable)this, FileDataSource.class.getName());
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public void stop() {
            this.stopped = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

