/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.value;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.client.value.LDValueType;
import com.launchdarkly.client.value.LDValueTypeAdapter;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import java.io.IOException;

@JsonAdapter(value=LDValueTypeAdapter.class)
final class LDValueArray
extends LDValue {
    private static final LDValueArray EMPTY = new LDValueArray(ImmutableList.of());
    private final ImmutableList<LDValue> list;

    static LDValueArray fromList(ImmutableList<LDValue> list) {
        return list.isEmpty() ? EMPTY : new LDValueArray(list);
    }

    private LDValueArray(ImmutableList<LDValue> list) {
        this.list = list;
    }

    @Override
    public LDValueType getType() {
        return LDValueType.ARRAY;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterable<LDValue> values() {
        return this.list;
    }

    @Override
    public LDValue get(int index) {
        if (index >= 0 && index < this.list.size()) {
            return (LDValue)this.list.get(index);
        }
        return LDValueArray.ofNull();
    }

    @Override
    void write(JsonWriter writer) throws IOException {
        writer.beginArray();
        for (LDValue v : this.list) {
            v.write(writer);
        }
        writer.endArray();
    }

    @Override
    JsonElement computeJsonElement() {
        JsonArray a = new JsonArray();
        for (LDValue item : this.list) {
            a.add(item.asUnsafeJsonElement());
        }
        return a;
    }
}

