/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.HttpErrorException;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.Segment;
import com.launchdarkly.client.Util;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.com.google.common.io.Files;
import com.launchdarkly.shaded.okhttp3.Cache;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultFeatureRequestor
implements FeatureRequestor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFeatureRequestor.class);
    private static final String GET_LATEST_FLAGS_PATH = "/sdk/latest-flags";
    private static final String GET_LATEST_SEGMENTS_PATH = "/sdk/latest-segments";
    private static final String GET_LATEST_ALL_PATH = "/sdk/latest-all";
    private static final long MAX_HTTP_CACHE_SIZE_BYTES = 0xA00000L;
    private final String sdkKey;
    private final LDConfig config;
    private final OkHttpClient httpClient;

    DefaultFeatureRequestor(String sdkKey, LDConfig config) {
        this.sdkKey = sdkKey;
        this.config = config;
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
        Util.configureHttpClientBuilder(config, httpBuilder);
        if (!config.stream) {
            File cacheDir = Files.createTempDir();
            Cache cache = new Cache(cacheDir, 0xA00000L);
            httpBuilder.cache(cache);
        }
        this.httpClient = httpBuilder.build();
    }

    @Override
    public void close() {
        Util.shutdownHttpClient(this.httpClient);
    }

    @Override
    public FeatureFlag getFlag(String featureKey) throws IOException, HttpErrorException {
        String body = this.get("/sdk/latest-flags/" + featureKey);
        return (FeatureFlag)this.config.gson.fromJson(body, FeatureFlag.class);
    }

    @Override
    public Segment getSegment(String segmentKey) throws IOException, HttpErrorException {
        String body = this.get("/sdk/latest-segments/" + segmentKey);
        return (Segment)this.config.gson.fromJson(body, Segment.class);
    }

    @Override
    public FeatureRequestor.AllData getAllData() throws IOException, HttpErrorException {
        String body = this.get(GET_LATEST_ALL_PATH);
        return (FeatureRequestor.AllData)this.config.gson.fromJson(body, FeatureRequestor.AllData.class);
    }

    static Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> toVersionedDataMap(FeatureRequestor.AllData allData) {
        HashMap ret = new HashMap();
        ret.put(VersionedDataKind.FEATURES, allData.flags);
        ret.put(VersionedDataKind.SEGMENTS, allData.segments);
        return ret;
    }

    private String get(String path) throws IOException, HttpErrorException {
        Request request = Util.getRequestBuilder(this.sdkKey).url(this.config.baseURI.resolve(path).toURL()).get().build();
        logger.debug("Making request: " + request);
        try (Response response = this.httpClient.newCall(request).execute();){
            String body = response.body().string();
            if (!response.isSuccessful()) {
                throw new HttpErrorException(response.code());
            }
            logger.debug("Get flag(s) response: " + response.toString() + " with body: " + body);
            logger.debug("Network response: " + response.networkResponse());
            if (!this.config.stream) {
                logger.debug("Cache hit count: " + this.httpClient.cache().hitCount() + " Cache network Count: " + this.httpClient.cache().networkCount());
                logger.debug("Cache response: " + response.cacheResponse());
            }
            String string = body;
            return string;
        }
    }
}

