/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.launchdarkly.client.Components;
import com.launchdarkly.client.EventProcessorFactory;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.UpdateProcessorFactory;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.Credentials;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import com.launchdarkly.shaded.okhttp3.Route;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDConfig {
    private static final Logger logger = LoggerFactory.getLogger(LDConfig.class);
    final Gson gson = new GsonBuilder().registerTypeAdapter(LDUser.class, (Object)new LDUser.UserAdapterWithPrivateAttributeBehavior(this)).create();
    private static final URI DEFAULT_BASE_URI = URI.create("https://app.launchdarkly.com");
    private static final URI DEFAULT_EVENTS_URI = URI.create("https://events.launchdarkly.com");
    private static final URI DEFAULT_STREAM_URI = URI.create("https://stream.launchdarkly.com");
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 10000;
    private static final int DEFAULT_FLUSH_INTERVAL_SECONDS = 5;
    private static final long MIN_POLLING_INTERVAL_MILLIS = 30000L;
    private static final long DEFAULT_START_WAIT_MILLIS = 5000L;
    private static final int DEFAULT_SAMPLING_INTERVAL = 0;
    private static final int DEFAULT_USER_KEYS_CAPACITY = 1000;
    private static final int DEFAULT_USER_KEYS_FLUSH_INTERVAL_SECONDS = 300;
    private static final long DEFAULT_RECONNECT_TIME_MILLIS = 1000L;
    protected static final LDConfig DEFAULT = new Builder().build();
    final URI baseURI;
    final URI eventsURI;
    final URI streamURI;
    final int capacity;
    final int flushInterval;
    final Proxy proxy;
    final Authenticator proxyAuthenticator;
    final boolean stream;
    final FeatureStore deprecatedFeatureStore;
    final FeatureStoreFactory featureStoreFactory;
    final EventProcessorFactory eventProcessorFactory;
    final UpdateProcessorFactory updateProcessorFactory;
    final boolean useLdd;
    final boolean offline;
    final boolean allAttributesPrivate;
    final Set<String> privateAttrNames;
    final boolean sendEvents;
    final long pollingIntervalMillis;
    final long startWaitMillis;
    final int samplingInterval;
    final long reconnectTimeMs;
    final int userKeysCapacity;
    final int userKeysFlushInterval;
    final boolean inlineUsersInEvents;
    final SSLSocketFactory sslSocketFactory;
    final X509TrustManager trustManager;
    final int connectTimeout;
    final TimeUnit connectTimeoutUnit;
    final int socketTimeout;
    final TimeUnit socketTimeoutUnit;

    protected LDConfig(Builder builder) {
        this.baseURI = builder.baseURI;
        this.eventsURI = builder.eventsURI;
        this.capacity = builder.capacity;
        this.flushInterval = builder.flushIntervalSeconds;
        this.proxy = builder.proxy();
        this.proxyAuthenticator = builder.proxyAuthenticator();
        this.streamURI = builder.streamURI;
        this.stream = builder.stream;
        this.deprecatedFeatureStore = builder.featureStore;
        this.featureStoreFactory = builder.featureStoreFactory;
        this.eventProcessorFactory = builder.eventProcessorFactory;
        this.updateProcessorFactory = builder.updateProcessorFactory;
        this.useLdd = builder.useLdd;
        this.offline = builder.offline;
        this.allAttributesPrivate = builder.allAttributesPrivate;
        this.privateAttrNames = new HashSet<String>(builder.privateAttrNames);
        this.sendEvents = builder.sendEvents;
        this.pollingIntervalMillis = builder.pollingIntervalMillis < 30000L ? 30000L : builder.pollingIntervalMillis;
        this.startWaitMillis = builder.startWaitMillis;
        this.samplingInterval = builder.samplingInterval;
        this.reconnectTimeMs = builder.reconnectTimeMillis;
        this.userKeysCapacity = builder.userKeysCapacity;
        this.userKeysFlushInterval = builder.userKeysFlushInterval;
        this.inlineUsersInEvents = builder.inlineUsersInEvents;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.trustManager = builder.trustManager;
        this.connectTimeout = builder.connectTimeout;
        this.connectTimeoutUnit = builder.connectTimeoutUnit;
        this.socketTimeout = builder.socketTimeout;
        this.socketTimeoutUnit = builder.socketTimeoutUnit;
        if (this.proxy != null) {
            if (this.proxyAuthenticator != null) {
                logger.info("Using proxy: " + this.proxy + " with authentication.");
            } else {
                logger.info("Using proxy: " + this.proxy + " without authentication.");
            }
        }
    }

    static /* synthetic */ URI access$2800() {
        return DEFAULT_BASE_URI;
    }

    static /* synthetic */ URI access$2900() {
        return DEFAULT_EVENTS_URI;
    }

    static /* synthetic */ URI access$3000() {
        return DEFAULT_STREAM_URI;
    }

    public static class Builder {
        private URI baseURI = LDConfig.access$2800();
        private URI eventsURI = LDConfig.access$2900();
        private URI streamURI = LDConfig.access$3000();
        private int connectTimeout = 2000;
        private TimeUnit connectTimeoutUnit = TimeUnit.MILLISECONDS;
        private int socketTimeout = 10000;
        private TimeUnit socketTimeoutUnit = TimeUnit.MILLISECONDS;
        private int capacity = 10000;
        private int flushIntervalSeconds = 5;
        private String proxyHost = "localhost";
        private int proxyPort = -1;
        private String proxyUsername = null;
        private String proxyPassword = null;
        private boolean stream = true;
        private boolean useLdd = false;
        private boolean offline = false;
        private boolean allAttributesPrivate = false;
        private boolean sendEvents = true;
        private long pollingIntervalMillis = 30000L;
        private FeatureStore featureStore = null;
        private FeatureStoreFactory featureStoreFactory = Components.inMemoryFeatureStore();
        private EventProcessorFactory eventProcessorFactory = Components.defaultEventProcessor();
        private UpdateProcessorFactory updateProcessorFactory = Components.defaultUpdateProcessor();
        private long startWaitMillis = 5000L;
        private int samplingInterval = 0;
        private long reconnectTimeMillis = 1000L;
        private Set<String> privateAttrNames = new HashSet<String>();
        private int userKeysCapacity = 1000;
        private int userKeysFlushInterval = 300;
        private boolean inlineUsersInEvents = false;
        private SSLSocketFactory sslSocketFactory = null;
        private X509TrustManager trustManager = null;

        public Builder baseURI(URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        public Builder eventsURI(URI eventsURI) {
            this.eventsURI = eventsURI;
            return this;
        }

        public Builder streamURI(URI streamURI) {
            this.streamURI = streamURI;
            return this;
        }

        public Builder featureStore(FeatureStore store) {
            this.featureStore = store;
            return this;
        }

        public Builder featureStoreFactory(FeatureStoreFactory factory) {
            this.featureStoreFactory = factory;
            return this;
        }

        public Builder eventProcessorFactory(EventProcessorFactory factory) {
            this.eventProcessorFactory = factory;
            return this;
        }

        public Builder updateProcessorFactory(UpdateProcessorFactory factory) {
            this.updateProcessorFactory = factory;
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            this.connectTimeoutUnit = TimeUnit.SECONDS;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            this.socketTimeoutUnit = TimeUnit.SECONDS;
            return this;
        }

        public Builder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeout = connectTimeoutMillis;
            this.connectTimeoutUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public Builder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeout = socketTimeoutMillis;
            this.socketTimeoutUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public Builder flushInterval(int flushInterval) {
            this.flushIntervalSeconds = flushInterval;
            return this;
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder proxyHost(String host) {
            this.proxyHost = host;
            return this;
        }

        public Builder proxyPort(int port) {
            this.proxyPort = port;
            return this;
        }

        public Builder proxyUsername(String username) {
            this.proxyUsername = username;
            return this;
        }

        public Builder proxyPassword(String password) {
            this.proxyPassword = password;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.trustManager = trustManager;
            return this;
        }

        public Builder useLdd(boolean useLdd) {
            this.useLdd = useLdd;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder allAttributesPrivate(boolean allPrivate) {
            this.allAttributesPrivate = allPrivate;
            return this;
        }

        public Builder sendEvents(boolean sendEvents) {
            this.sendEvents = sendEvents;
            return this;
        }

        public Builder pollingIntervalMillis(long pollingIntervalMillis) {
            this.pollingIntervalMillis = pollingIntervalMillis;
            return this;
        }

        public Builder startWaitMillis(long startWaitMillis) {
            this.startWaitMillis = startWaitMillis;
            return this;
        }

        @Deprecated
        public Builder samplingInterval(int samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMillis = reconnectTimeMs;
            return this;
        }

        public Builder privateAttributeNames(String ... names) {
            this.privateAttrNames = new HashSet<String>(Arrays.asList(names));
            return this;
        }

        public Builder userKeysCapacity(int capacity) {
            this.userKeysCapacity = capacity;
            return this;
        }

        public Builder userKeysFlushInterval(int flushInterval) {
            this.userKeysFlushInterval = flushInterval;
            return this;
        }

        public Builder inlineUsersInEvents(boolean inlineUsersInEvents) {
            this.inlineUsersInEvents = inlineUsersInEvents;
            return this;
        }

        Proxy proxy() {
            if (this.proxyPort == -1) {
                return null;
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }

        Authenticator proxyAuthenticator() {
            if (this.proxyUsername != null && this.proxyPassword != null) {
                final String credential = Credentials.basic(this.proxyUsername, this.proxyPassword);
                return new Authenticator(){

                    @Override
                    public Request authenticate(Route route, Response response) throws IOException {
                        if (response.request().header("Proxy-Authorization") != null) {
                            return null;
                        }
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
            }
            return null;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

