/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.sdk.json.SerializationException;
import java.io.IOException;
import java.lang.reflect.Type;

public abstract class LDGson {
    public static TypeAdapterFactory typeAdapters() {
        return LDTypeAdapterFactory.INSTANCE;
    }

    private static class LDTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Gson gson;
        private final Type objectType;

        LDTypeAdapter(Gson gson, Type objectType) {
            this.gson = gson;
            this.objectType = objectType;
        }

        public void write(JsonWriter out, T value) throws IOException {
            String json = JsonSerialization.serializeInternal(value);
            out.jsonValue(json);
        }

        public T read(JsonReader in) throws IOException {
            JsonElement jsonTree = (JsonElement)this.gson.fromJson(in, JsonElement.class);
            String jsonString = this.gson.toJson(jsonTree);
            try {
                return JsonSerialization.deserializeInternalGson(jsonString, this.objectType);
            }
            catch (SerializationException e) {
                throw new JsonParseException(e.getCause());
            }
        }
    }

    private static class LDTypeAdapterFactory
    implements TypeAdapterFactory {
        private static LDTypeAdapterFactory INSTANCE = new LDTypeAdapterFactory();

        private LDTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (JsonSerializable.class.isAssignableFrom(type.getRawType())) {
                return new LDTypeAdapter(gson, type.getType());
            }
            return null;
        }
    }
}

