/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DiagnosticAccumulator;
import com.launchdarkly.sdk.server.DiagnosticEvent;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;

final class ClientContextImpl
implements ClientContext {
    private final String sdkKey;
    private final HttpConfiguration httpConfiguration;
    private final boolean offline;
    private final DiagnosticAccumulator diagnosticAccumulator;
    private final DiagnosticEvent.Init diagnosticInitEvent;

    ClientContextImpl(String sdkKey, LDConfig configuration, DiagnosticAccumulator diagnosticAccumulator) {
        this.sdkKey = sdkKey;
        this.httpConfiguration = configuration.httpConfig;
        this.offline = configuration.offline;
        if (!configuration.diagnosticOptOut && diagnosticAccumulator != null) {
            this.diagnosticAccumulator = diagnosticAccumulator;
            this.diagnosticInitEvent = new DiagnosticEvent.Init(diagnosticAccumulator.dataSinceDate, diagnosticAccumulator.diagnosticId, configuration);
        } else {
            this.diagnosticAccumulator = null;
            this.diagnosticInitEvent = null;
        }
    }

    @Override
    public String getSdkKey() {
        return this.sdkKey;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    DiagnosticAccumulator getDiagnosticAccumulator() {
        return this.diagnosticAccumulator;
    }

    DiagnosticEvent.Init getDiagnosticInitEvent() {
        return this.diagnosticInitEvent;
    }

    static DiagnosticAccumulator getDiagnosticAccumulator(ClientContext context) {
        if (context instanceof ClientContextImpl) {
            return ((ClientContextImpl)context).getDiagnosticAccumulator();
        }
        return null;
    }

    static DiagnosticEvent.Init getDiagnosticInitEvent(ClientContext context) {
        if (context instanceof ClientContextImpl) {
            return ((ClientContextImpl)context).getDiagnosticInitEvent();
        }
        return null;
    }
}

