/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelDependencies;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.FlagChangeEventPublisher;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.DataStoreUpdates;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class DataStoreUpdatesImpl
implements DataStoreUpdates {
    private final DataStore store;
    private final FlagChangeEventPublisher flagChangeEventPublisher;
    private final DataModelDependencies.DependencyTracker dependencyTracker = new DataModelDependencies.DependencyTracker();
    private final DataStoreStatusProvider dataStoreStatusProvider;

    DataStoreUpdatesImpl(DataStore store, FlagChangeEventPublisher flagChangeEventPublisher) {
        this.store = store;
        this.flagChangeEventPublisher = flagChangeEventPublisher;
        this.dataStoreStatusProvider = new DataStoreStatusProviderImpl(store);
    }

    @Override
    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldData = null;
        if (this.hasFlagChangeEventListeners()) {
            oldData = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
            for (DataStoreTypes.DataKind kind : DataModel.ALL_DATA_KINDS) {
                DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items = this.store.getAll(kind);
                oldData.put(kind, ImmutableMap.copyOf(items.getItems()));
            }
        }
        this.store.init(DataModelDependencies.sortAllCollections(allData));
        this.updateDependencyTrackerFromFullDataSet(allData);
        if (oldData != null) {
            this.sendChangeEvents(this.computeChangedItemsForFullDataSet(oldData, this.fullDataSetToMap(allData)));
        }
    }

    @Override
    public void upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        boolean successfullyUpdated = this.store.upsert(kind, key, item);
        if (successfullyUpdated) {
            this.dependencyTracker.updateDependenciesFrom(kind, key, item);
            if (this.hasFlagChangeEventListeners()) {
                HashSet<DataModelDependencies.KindAndKey> affectedItems = new HashSet<DataModelDependencies.KindAndKey>();
                this.dependencyTracker.addAffectedItems(affectedItems, new DataModelDependencies.KindAndKey(kind, key));
                this.sendChangeEvents(affectedItems);
            }
        }
    }

    @Override
    public DataStoreStatusProvider getStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    private boolean hasFlagChangeEventListeners() {
        return this.flagChangeEventPublisher != null && this.flagChangeEventPublisher.hasListeners();
    }

    private void sendChangeEvents(Iterable<DataModelDependencies.KindAndKey> affectedItems) {
        if (this.flagChangeEventPublisher == null) {
            return;
        }
        for (DataModelDependencies.KindAndKey item : affectedItems) {
            if (item.kind != DataModel.FEATURES) continue;
            this.flagChangeEventPublisher.publishEvent(new FlagChangeEvent(item.key));
        }
    }

    private void updateDependencyTrackerFromFullDataSet(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        this.dependencyTracker.reset();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e0 : allData.getData()) {
            DataStoreTypes.DataKind kind = e0.getKey();
            for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e1 : e0.getValue().getItems()) {
                String key = e1.getKey();
                this.dependencyTracker.updateDependenciesFrom(kind, key, e1.getValue());
            }
        }
    }

    private Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> fullDataSetToMap(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> ret = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e : allData.getData()) {
            ret.put(e.getKey(), ImmutableMap.copyOf(e.getValue().getItems()));
        }
        return ret;
    }

    private Set<DataModelDependencies.KindAndKey> computeChangedItemsForFullDataSet(Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldDataMap, Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> newDataMap) {
        HashSet<DataModelDependencies.KindAndKey> affectedItems = new HashSet<DataModelDependencies.KindAndKey>();
        for (DataStoreTypes.DataKind kind : DataModel.ALL_DATA_KINDS) {
            Map<String, DataStoreTypes.ItemDescriptor> oldItems = oldDataMap.get(kind);
            Map<String, DataStoreTypes.ItemDescriptor> newItems = newDataMap.get(kind);
            if (oldItems == null) {
                oldItems = Collections.emptyMap();
            }
            if (newItems == null) {
                newItems = Collections.emptyMap();
            }
            ImmutableSet<String> allKeys = ImmutableSet.copyOf(Iterables.concat(oldItems.keySet(), newItems.keySet()));
            for (String key : allKeys) {
                DataStoreTypes.ItemDescriptor oldItem = oldItems.get(key);
                DataStoreTypes.ItemDescriptor newItem = newItems.get(key);
                if (oldItem == null && newItem == null || oldItem != null && newItem != null && oldItem.getVersion() >= newItem.getVersion()) continue;
                this.dependencyTracker.addAffectedItems(affectedItems, new DataModelDependencies.KindAndKey(kind, key));
            }
        }
        return affectedItems;
    }
}

