/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.server.DiagnosticAccumulator;
import com.launchdarkly.sdk.server.DiagnosticEvent;
import com.launchdarkly.sdk.server.EventFactory;
import com.launchdarkly.sdk.server.EventOutputFormatter;
import com.launchdarkly.sdk.server.EventSummarizer;
import com.launchdarkly.sdk.server.EventsConfiguration;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.SimpleLRUCache;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.sdk.server.interfaces.EventProcessor;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.MediaType;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.RequestBody;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventProcessor.class);
    private static final String EVENT_SCHEMA_HEADER = "X-LaunchDarkly-Event-Schema";
    private static final String EVENT_SCHEMA_VERSION = "3";
    private static final String EVENT_PAYLOAD_ID_HEADER = "X-LaunchDarkly-Payload-ID";
    private static final MediaType JSON_CONTENT_TYPE = MediaType.parse("application/json; charset=utf-8");
    @VisibleForTesting
    final EventDispatcher dispatcher;
    private final BlockingQueue<EventProcessorMessage> inbox;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean inputCapacityExceeded = false;

    DefaultEventProcessor(String sdkKey, EventsConfiguration eventsConfig, HttpConfiguration httpConfig, DiagnosticAccumulator diagnosticAccumulator, DiagnosticEvent.Init diagnosticInitEvent) {
        this.inbox = new ArrayBlockingQueue<EventProcessorMessage>(eventsConfig.capacity);
        ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-EventProcessor-%d").setPriority(1).build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory2);
        this.dispatcher = new EventDispatcher(sdkKey, eventsConfig, httpConfig, this.inbox, threadFactory2, this.closed, diagnosticAccumulator, diagnosticInitEvent);
        Runnable flusher = () -> this.postMessageAsync(MessageType.FLUSH, null);
        this.scheduler.scheduleAtFixedRate(flusher, eventsConfig.flushInterval.toMillis(), eventsConfig.flushInterval.toMillis(), TimeUnit.MILLISECONDS);
        Runnable userKeysFlusher = () -> this.postMessageAsync(MessageType.FLUSH_USERS, null);
        this.scheduler.scheduleAtFixedRate(userKeysFlusher, eventsConfig.userKeysFlushInterval.toMillis(), eventsConfig.userKeysFlushInterval.toMillis(), TimeUnit.MILLISECONDS);
        if (diagnosticAccumulator != null) {
            Runnable diagnosticsTrigger = () -> this.postMessageAsync(MessageType.DIAGNOSTIC, null);
            this.scheduler.scheduleAtFixedRate(diagnosticsTrigger, eventsConfig.diagnosticRecordingInterval.toMillis(), eventsConfig.diagnosticRecordingInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void sendEvent(Event e) {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.EVENT, e);
        }
    }

    @Override
    public void flush() {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.FLUSH, null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduler.shutdown();
            this.postMessageAsync(MessageType.FLUSH, null);
            this.postMessageAndWait(MessageType.SHUTDOWN, null);
        }
    }

    @VisibleForTesting
    void waitUntilInactive() throws IOException {
        this.postMessageAndWait(MessageType.SYNC, null);
    }

    @VisibleForTesting
    void postDiagnostic() {
        this.postMessageAsync(MessageType.DIAGNOSTIC, null);
    }

    private void postMessageAsync(MessageType type, Event event) {
        this.postToChannel(new EventProcessorMessage(type, event, false));
    }

    private void postMessageAndWait(MessageType type, Event event) {
        EventProcessorMessage message = new EventProcessorMessage(type, event, true);
        if (this.postToChannel(message)) {
            message.waitForCompletion();
        }
    }

    private boolean postToChannel(EventProcessorMessage message) {
        if (this.inbox.offer(message)) {
            return true;
        }
        boolean alreadyLogged = this.inputCapacityExceeded;
        this.inputCapacityExceeded = true;
        if (!alreadyLogged) {
            logger.warn("Events are being produced faster than they can be processed; some events will be dropped");
        }
        return false;
    }

    private static void postJson(OkHttpClient httpClient, Headers headers, String json, String uriStr, String descriptor, EventResponseListener responseListener, SimpleDateFormat dateFormat) {
        logger.debug("Posting {} to {} with payload: {}", new Object[]{descriptor, uriStr, json});
        for (int attempt = 0; attempt < 2; ++attempt) {
            if (attempt > 0) {
                logger.warn("Will retry posting {} after 1 second", (Object)descriptor);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Request request = new Request.Builder().url(uriStr).post(RequestBody.create(json, JSON_CONTENT_TYPE)).headers(headers).build();
            long startTime = System.currentTimeMillis();
            try (Response response = httpClient.newCall(request).execute();){
                String dateStr;
                long endTime = System.currentTimeMillis();
                logger.debug("{} delivery took {} ms, response status {}", new Object[]{descriptor, endTime - startTime, response.code()});
                if (!response.isSuccessful()) {
                    logger.warn("Unexpected response status when posting {}: {}", (Object)descriptor, (Object)response.code());
                    if (Util.isHttpErrorRecoverable(response.code())) continue;
                }
                if (responseListener == null) break;
                Date respDate = null;
                if (dateFormat != null && (dateStr = response.header("Date")) != null) {
                    try {
                        respDate = dateFormat.parse(dateStr);
                    }
                    catch (ParseException e) {
                        logger.warn("Received invalid Date header from events service");
                    }
                }
                responseListener.handleResponse(response, respDate);
                break;
            }
            catch (IOException e) {
                logger.warn("Unhandled exception in LaunchDarkly client when posting events to URL: {} ({})", (Object)request.url(), (Object)e.toString());
                logger.debug(e.toString(), (Throwable)e);
            }
        }
    }

    private static final class SendDiagnosticTaskFactory {
        private final OkHttpClient httpClient;
        private final String uriStr;
        private final Headers headers;

        SendDiagnosticTaskFactory(String sdkKey, EventsConfiguration eventsConfig, OkHttpClient httpClient, HttpConfiguration httpConfig) {
            this.httpClient = httpClient;
            this.uriStr = eventsConfig.eventsUri.toString() + "/diagnostic";
            this.headers = Util.getHeadersBuilderFor(sdkKey, httpConfig).add("Content-Type", "application/json").build();
        }

        Runnable createSendDiagnosticTask(final DiagnosticEvent diagnosticEvent) {
            return new Runnable(){

                @Override
                public void run() {
                    String json = JsonHelpers.serialize(diagnosticEvent);
                    DefaultEventProcessor.postJson(httpClient, headers, json, uriStr, "diagnostic event", null, null);
                }
            };
        }
    }

    private static final class SendEventsTask
    implements Runnable {
        private final OkHttpClient httpClient;
        private final EventResponseListener responseListener;
        private final BlockingQueue<FlushPayload> payloadQueue;
        private final AtomicInteger activeFlushWorkersCount;
        private final AtomicBoolean stopping;
        private final EventOutputFormatter formatter;
        private final Thread thread;
        private final Headers headers;
        private final String uriStr;
        private final SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");

        SendEventsTask(String sdkKey, EventsConfiguration eventsConfig, OkHttpClient httpClient, HttpConfiguration httpConfig, EventResponseListener responseListener, BlockingQueue<FlushPayload> payloadQueue, AtomicInteger activeFlushWorkersCount, ThreadFactory threadFactory2) {
            this.httpClient = httpClient;
            this.formatter = new EventOutputFormatter(eventsConfig);
            this.responseListener = responseListener;
            this.payloadQueue = payloadQueue;
            this.activeFlushWorkersCount = activeFlushWorkersCount;
            this.stopping = new AtomicBoolean(false);
            this.uriStr = eventsConfig.eventsUri.toString() + "/bulk";
            this.headers = Util.getHeadersBuilderFor(sdkKey, httpConfig).add("Content-Type", "application/json").add(DefaultEventProcessor.EVENT_SCHEMA_HEADER, DefaultEventProcessor.EVENT_SCHEMA_VERSION).build();
            this.thread = threadFactory2.newThread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopping.get()) {
                FlushPayload payload = null;
                try {
                    payload = this.payloadQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    StringWriter stringWriter = new StringWriter();
                    int outputEventCount = this.formatter.writeOutputEvents(payload.events, payload.summary, stringWriter);
                    if (outputEventCount > 0) {
                        this.postEvents(stringWriter.toString(), outputEventCount);
                    }
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                }
                AtomicInteger atomicInteger = this.activeFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.activeFlushWorkersCount.decrementAndGet();
                    this.activeFlushWorkersCount.notifyAll();
                }
            }
        }

        void stop() {
            this.stopping.set(true);
            this.thread.interrupt();
        }

        private void postEvents(String json, int outputEventCount) {
            String eventPayloadId = UUID.randomUUID().toString();
            Headers newHeaders = this.headers.newBuilder().add(DefaultEventProcessor.EVENT_PAYLOAD_ID_HEADER, eventPayloadId).build();
            DefaultEventProcessor.postJson(this.httpClient, newHeaders, json, this.uriStr, String.format("%d event(s)", outputEventCount), this.responseListener, this.httpDateFormat);
        }
    }

    private static interface EventResponseListener {
        public void handleResponse(Response var1, Date var2);
    }

    private static final class FlushPayload {
        final Event[] events;
        final EventSummarizer.EventSummary summary;

        FlushPayload(Event[] events, EventSummarizer.EventSummary summary) {
            this.events = events;
            this.summary = summary;
        }
    }

    private static final class EventBuffer {
        final List<Event> events = new ArrayList<Event>();
        final EventSummarizer summarizer = new EventSummarizer();
        private final int capacity;
        private boolean capacityExceeded = false;
        private long droppedEventCount = 0L;

        EventBuffer(int capacity) {
            this.capacity = capacity;
        }

        void add(Event e) {
            if (this.events.size() >= this.capacity) {
                if (!this.capacityExceeded) {
                    this.capacityExceeded = true;
                    logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
                }
                ++this.droppedEventCount;
            } else {
                this.capacityExceeded = false;
                this.events.add(e);
            }
        }

        void addToSummary(Event e) {
            this.summarizer.summarizeEvent(e);
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.summarizer.snapshot().isEmpty();
        }

        long getAndClearDroppedCount() {
            long res = this.droppedEventCount;
            this.droppedEventCount = 0L;
            return res;
        }

        FlushPayload getPayload() {
            Event[] eventsOut = this.events.toArray(new Event[this.events.size()]);
            EventSummarizer.EventSummary summary = this.summarizer.snapshot();
            return new FlushPayload(eventsOut, summary);
        }

        void clear() {
            this.events.clear();
            this.summarizer.clear();
        }
    }

    static final class EventDispatcher {
        private static final int MAX_FLUSH_THREADS = 5;
        private static final int MESSAGE_BATCH_SIZE = 50;
        @VisibleForTesting
        final EventsConfiguration eventsConfig;
        private final OkHttpClient httpClient;
        private final List<SendEventsTask> flushWorkers;
        private final AtomicInteger busyFlushWorkersCount;
        private final AtomicLong lastKnownPastTime = new AtomicLong(0L);
        private final AtomicBoolean disabled = new AtomicBoolean(false);
        @VisibleForTesting
        final DiagnosticAccumulator diagnosticAccumulator;
        private final ExecutorService diagnosticExecutor;
        private final SendDiagnosticTaskFactory sendDiagnosticTaskFactory;
        private long deduplicatedUsers = 0L;

        private EventDispatcher(String sdkKey, EventsConfiguration eventsConfig, HttpConfiguration httpConfig, final BlockingQueue<EventProcessorMessage> inbox, ThreadFactory threadFactory2, final AtomicBoolean closed, DiagnosticAccumulator diagnosticAccumulator, DiagnosticEvent.Init diagnosticInitEvent) {
            this.eventsConfig = eventsConfig;
            this.diagnosticAccumulator = diagnosticAccumulator;
            this.busyFlushWorkersCount = new AtomicInteger(0);
            OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
            Util.configureHttpClientBuilder(httpConfig, httpBuilder);
            this.httpClient = httpBuilder.build();
            ArrayBlockingQueue<FlushPayload> payloadQueue = new ArrayBlockingQueue<FlushPayload>(1);
            EventBuffer outbox = new EventBuffer(eventsConfig.capacity);
            SimpleLRUCache userKeys = new SimpleLRUCache(eventsConfig.userKeysCapacity);
            Thread mainThread = threadFactory2.newThread(() -> this.runMainLoop(inbox, outbox, userKeys, payloadQueue));
            mainThread.setDaemon(true);
            mainThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    logger.error("Event processor thread was terminated by an unrecoverable error. No more analytics events will be sent.", e);
                    closed.set(true);
                    ArrayList messages = new ArrayList();
                    inbox.drainTo(messages);
                    for (EventProcessorMessage m3 : messages) {
                        m3.completed();
                    }
                }
            });
            mainThread.start();
            this.flushWorkers = new ArrayList<SendEventsTask>();
            EventResponseListener listener = this::handleResponse;
            for (int i = 0; i < 5; ++i) {
                SendEventsTask task = new SendEventsTask(sdkKey, eventsConfig, this.httpClient, httpConfig, listener, payloadQueue, this.busyFlushWorkersCount, threadFactory2);
                this.flushWorkers.add(task);
            }
            if (diagnosticAccumulator != null) {
                this.sendDiagnosticTaskFactory = new SendDiagnosticTaskFactory(sdkKey, eventsConfig, this.httpClient, httpConfig);
                this.diagnosticExecutor = Executors.newSingleThreadExecutor(threadFactory2);
                this.diagnosticExecutor.submit(this.sendDiagnosticTaskFactory.createSendDiagnosticTask(diagnosticInitEvent));
            } else {
                this.diagnosticExecutor = null;
                this.sendDiagnosticTaskFactory = null;
            }
        }

        private void runMainLoop(BlockingQueue<EventProcessorMessage> inbox, EventBuffer outbox, SimpleLRUCache<String, String> userKeys, BlockingQueue<FlushPayload> payloadQueue) {
            ArrayList<EventProcessorMessage> batch = new ArrayList<EventProcessorMessage>(50);
            while (true) {
                try {
                    block12: while (true) {
                        batch.clear();
                        batch.add(inbox.take());
                        inbox.drainTo(batch, 49);
                        Iterator iterator2 = batch.iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block12;
                            EventProcessorMessage message = (EventProcessorMessage)iterator2.next();
                            switch (message.type) {
                                case EVENT: {
                                    this.processEvent(message.event, userKeys, outbox);
                                    break;
                                }
                                case FLUSH: {
                                    this.triggerFlush(outbox, payloadQueue);
                                    break;
                                }
                                case FLUSH_USERS: {
                                    userKeys.clear();
                                    break;
                                }
                                case DIAGNOSTIC: {
                                    this.sendAndResetDiagnostics(outbox);
                                    break;
                                }
                                case SYNC: {
                                    this.waitUntilAllFlushWorkersInactive();
                                    break;
                                }
                                case SHUTDOWN: {
                                    this.doShutdown();
                                    message.completed();
                                    return;
                                }
                            }
                            message.completed();
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void sendAndResetDiagnostics(EventBuffer outbox) {
            long droppedEvents = outbox.getAndClearDroppedCount();
            DiagnosticEvent.Statistics diagnosticEvent = this.diagnosticAccumulator.createEventAndReset(droppedEvents, this.deduplicatedUsers);
            this.deduplicatedUsers = 0L;
            this.diagnosticExecutor.submit(this.sendDiagnosticTaskFactory.createSendDiagnosticTask(diagnosticEvent));
        }

        private void doShutdown() {
            this.waitUntilAllFlushWorkersInactive();
            this.disabled.set(true);
            for (SendEventsTask task : this.flushWorkers) {
                task.stop();
            }
            if (this.diagnosticExecutor != null) {
                this.diagnosticExecutor.shutdown();
            }
            Util.shutdownHttpClient(this.httpClient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitUntilAllFlushWorkersInactive() {
            while (true) {
                try {
                    while (true) {
                        AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                        synchronized (atomicInteger) {
                            if (this.busyFlushWorkersCount.get() == 0) {
                                return;
                            }
                            this.busyFlushWorkersCount.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void processEvent(Event e, SimpleLRUCache<String, String> userKeys, EventBuffer outbox) {
            LDUser user;
            if (this.disabled.get()) {
                return;
            }
            outbox.addToSummary(e);
            boolean addIndexEvent = false;
            boolean addFullEvent = false;
            Event.FeatureRequest debugEvent = null;
            if (e instanceof Event.FeatureRequest) {
                Event.FeatureRequest fe = (Event.FeatureRequest)e;
                addFullEvent = fe.isTrackEvents();
                if (this.shouldDebugEvent(fe)) {
                    debugEvent = EventFactory.DEFAULT.newDebugEvent(fe);
                }
            } else {
                addFullEvent = true;
            }
            if (!(addFullEvent && this.eventsConfig.inlineUsersInEvents || (user = e.getUser()) == null || user.getKey() == null)) {
                boolean isIndexEvent = e instanceof Event.Identify;
                boolean alreadySeen = this.noticeUser(user, userKeys);
                addIndexEvent = !isIndexEvent & !alreadySeen;
                if (!isIndexEvent & alreadySeen) {
                    ++this.deduplicatedUsers;
                }
            }
            if (addIndexEvent) {
                Event.Index ie = new Event.Index(e.getCreationDate(), e.getUser());
                outbox.add(ie);
            }
            if (addFullEvent) {
                outbox.add(e);
            }
            if (debugEvent != null) {
                outbox.add(debugEvent);
            }
        }

        private boolean noticeUser(LDUser user, SimpleLRUCache<String, String> userKeys) {
            if (user == null || user.getKey() == null) {
                return false;
            }
            String key = user.getKey();
            return userKeys.put(key, key) != null;
        }

        private boolean shouldDebugEvent(Event.FeatureRequest fe) {
            long lastPast;
            long debugEventsUntilDate = fe.getDebugEventsUntilDate();
            return debugEventsUntilDate > 0L && debugEventsUntilDate > (lastPast = this.lastKnownPastTime.get()) && debugEventsUntilDate > System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerFlush(EventBuffer outbox, BlockingQueue<FlushPayload> payloadQueue) {
            if (this.disabled.get() || outbox.isEmpty()) {
                return;
            }
            FlushPayload payload = outbox.getPayload();
            if (this.diagnosticAccumulator != null) {
                this.diagnosticAccumulator.recordEventsInBatch(payload.events.length);
            }
            this.busyFlushWorkersCount.incrementAndGet();
            if (payloadQueue.offer(payload)) {
                outbox.clear();
            } else {
                logger.debug("Skipped flushing because all workers are busy");
                AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.busyFlushWorkersCount.decrementAndGet();
                    this.busyFlushWorkersCount.notify();
                }
            }
        }

        private void handleResponse(Response response, Date responseDate) {
            if (responseDate != null) {
                this.lastKnownPastTime.set(responseDate.getTime());
            }
            if (!Util.isHttpErrorRecoverable(response.code())) {
                this.disabled.set(true);
                logger.error(Util.httpErrorMessage(response.code(), "posting events", "some events were dropped"));
            }
        }
    }

    private static final class EventProcessorMessage {
        private final MessageType type;
        private final Event event;
        private final Semaphore reply;

        private EventProcessorMessage(MessageType type, Event event, boolean sync) {
            this.type = type;
            this.event = event;
            this.reply = sync ? new Semaphore(0) : null;
        }

        void completed() {
            if (this.reply != null) {
                this.reply.release();
            }
        }

        void waitForCompletion() {
            if (this.reply == null) {
                return;
            }
            while (true) {
                try {
                    this.reply.acquire();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public String toString() {
            return (this.event == null ? this.type.toString() : (Object)((Object)this.type) + ": " + this.event.getClass().getSimpleName()) + (this.reply == null ? "" : " (sync)");
        }
    }

    private static enum MessageType {
        EVENT,
        FLUSH,
        FLUSH_USERS,
        DIAGNOSTIC,
        SYNC,
        SHUTDOWN;

    }
}

