/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.EventSummarizer;
import com.launchdarkly.sdk.server.EventsConfiguration;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.shaded.com.google.gson.Gson;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;

final class EventOutputFormatter {
    private final EventsConfiguration config;
    private final Gson gson;

    EventOutputFormatter(EventsConfiguration config) {
        this.config = config;
        this.gson = JsonHelpers.gsonInstanceForEventsSerialization(config);
    }

    int writeOutputEvents(Event[] events, EventSummarizer.EventSummary summary, Writer writer) throws IOException {
        int count = 0;
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            jsonWriter.beginArray();
            for (Event event : events) {
                if (!this.writeOutputEvent(event, jsonWriter)) continue;
                ++count;
            }
            if (!summary.isEmpty()) {
                this.writeSummaryEvent(summary, jsonWriter);
                ++count;
            }
            jsonWriter.endArray();
        }
        return count;
    }

    private boolean writeOutputEvent(Event event, JsonWriter jw) throws IOException {
        if (event instanceof Event.FeatureRequest) {
            Event.FeatureRequest fe;
            this.startEvent(fe, (fe = (Event.FeatureRequest)event).isDebug() ? "debug" : "feature", fe.getKey(), jw);
            this.writeUserOrKey(fe, fe.isDebug(), jw);
            if (fe.getVersion() >= 0) {
                jw.name("version");
                jw.value(fe.getVersion());
            }
            if (fe.getVariation() >= 0) {
                jw.name("variation");
                jw.value(fe.getVariation());
            }
            this.writeLDValue("value", fe.getValue(), jw);
            this.writeLDValue("default", fe.getDefaultVal(), jw);
            if (fe.getPrereqOf() != null) {
                jw.name("prereqOf");
                jw.value(fe.getPrereqOf());
            }
            this.writeEvaluationReason("reason", fe.getReason(), jw);
            jw.endObject();
        } else if (event instanceof Event.Identify) {
            this.startEvent(event, "identify", event.getUser() == null ? null : event.getUser().getKey(), jw);
            this.writeUser(event.getUser(), jw);
            jw.endObject();
        } else if (event instanceof Event.Custom) {
            Event.Custom ce = (Event.Custom)event;
            this.startEvent(event, "custom", ce.getKey(), jw);
            this.writeUserOrKey(ce, false, jw);
            this.writeLDValue("data", ce.getData(), jw);
            if (ce.getMetricValue() != null) {
                jw.name("metricValue");
                jw.value(ce.getMetricValue());
            }
            jw.endObject();
        } else if (event instanceof Event.Index) {
            this.startEvent(event, "index", null, jw);
            this.writeUser(event.getUser(), jw);
            jw.endObject();
        } else {
            return false;
        }
        return true;
    }

    private void writeSummaryEvent(EventSummarizer.EventSummary summary, JsonWriter jw) throws IOException {
        jw.beginObject();
        jw.name("kind");
        jw.value("summary");
        jw.name("startDate");
        jw.value(summary.startDate);
        jw.name("endDate");
        jw.value(summary.endDate);
        jw.name("features");
        jw.beginObject();
        EventSummarizer.CounterKey[] unprocessedKeys = summary.counters.keySet().toArray(new EventSummarizer.CounterKey[summary.counters.size()]);
        for (int i = 0; i < unprocessedKeys.length; ++i) {
            if (unprocessedKeys[i] == null) continue;
            EventSummarizer.CounterKey key = unprocessedKeys[i];
            String flagKey = key.key;
            EventSummarizer.CounterValue firstValue = summary.counters.get(key);
            jw.name(flagKey);
            jw.beginObject();
            this.writeLDValue("default", firstValue.defaultVal, jw);
            jw.name("counters");
            jw.beginArray();
            for (int j = i; j < unprocessedKeys.length; ++j) {
                EventSummarizer.CounterKey keyForThisFlag = unprocessedKeys[j];
                if (j != i && (keyForThisFlag == null || !keyForThisFlag.key.equals(flagKey))) continue;
                EventSummarizer.CounterValue value = keyForThisFlag == key ? firstValue : summary.counters.get(keyForThisFlag);
                unprocessedKeys[j] = null;
                jw.beginObject();
                if (keyForThisFlag.variation >= 0) {
                    jw.name("variation");
                    jw.value(keyForThisFlag.variation);
                }
                if (keyForThisFlag.version >= 0) {
                    jw.name("version");
                    jw.value(keyForThisFlag.version);
                } else {
                    jw.name("unknown");
                    jw.value(true);
                }
                this.writeLDValue("value", value.flagValue, jw);
                jw.name("count");
                jw.value(value.count);
                jw.endObject();
            }
            jw.endArray();
            jw.endObject();
        }
        jw.endObject();
        jw.endObject();
    }

    private void startEvent(Event event, String kind, String key, JsonWriter jw) throws IOException {
        jw.beginObject();
        jw.name("kind");
        jw.value(kind);
        jw.name("creationDate");
        jw.value(event.getCreationDate());
        if (key != null) {
            jw.name("key");
            jw.value(key);
        }
    }

    private void writeUserOrKey(Event event, boolean forceInline, JsonWriter jw) throws IOException {
        LDUser user = event.getUser();
        if (user != null) {
            if (this.config.inlineUsersInEvents || forceInline) {
                this.writeUser(user, jw);
            } else {
                jw.name("userKey");
                jw.value(user.getKey());
            }
        }
    }

    private void writeUser(LDUser user, JsonWriter jw) throws IOException {
        jw.name("user");
        this.gson.toJson((Object)user, (Type)((Object)LDUser.class), jw);
    }

    private void writeLDValue(String key, LDValue value, JsonWriter jw) throws IOException {
        if (value == null || value.isNull()) {
            return;
        }
        jw.name(key);
        this.gson.toJson((Object)value, (Type)((Object)LDValue.class), jw);
    }

    private void writeEvaluationReason(String key, EvaluationReason er, JsonWriter jw) throws IOException {
        if (er == null) {
            return;
        }
        jw.name(key);
        jw.beginObject();
        jw.name("kind");
        jw.value(er.getKind().name());
        switch (er.getKind()) {
            case ERROR: {
                jw.name("errorKind");
                jw.value(er.getErrorKind().name());
                break;
            }
            case PREREQUISITE_FAILED: {
                jw.name("prerequisiteKey");
                jw.value(er.getPrerequisiteKey());
                break;
            }
            case RULE_MATCH: {
                jw.name("ruleIndex");
                jw.value(er.getRuleIndex());
                if (er.getRuleId() == null) break;
                jw.name("ruleId");
                jw.value(er.getRuleId());
                break;
            }
        }
        jw.endObject();
    }
}

