/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

final class FlagChangeEventPublisher
implements Closeable {
    private final CopyOnWriteArrayList<FlagChangeListener> listeners = new CopyOnWriteArrayList();
    private volatile ExecutorService executor = null;

    FlagChangeEventPublisher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(FlagChangeListener listener) {
        this.listeners.add(listener);
        FlagChangeEventPublisher flagChangeEventPublisher = this;
        synchronized (flagChangeEventPublisher) {
            if (this.executor == null) {
                this.executor = this.createExecutorService();
            }
        }
    }

    public void unregister(FlagChangeListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void publishEvent(FlagChangeEvent event) {
        for (FlagChangeListener l : this.listeners) {
            this.executor.execute(() -> l.onFlagChange(event));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private ExecutorService createExecutorService() {
        ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-FlagChangeEventPublisher-%d").setPriority(1).build();
        return Executors.newCachedThreadPool(threadFactory2);
    }
}

