/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.DiagnosticDescription;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;

class InMemoryDataStore
implements DataStore,
DiagnosticDescription {
    private volatile ImmutableMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> allData = ImmutableMap.of();
    private volatile boolean initialized = false;
    private Object writeLock = new Object();

    InMemoryDataStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        Object object = this.writeLock;
        synchronized (object) {
            ImmutableMap.Builder<DataStoreTypes.DataKind, ImmutableMap<String, DataStoreTypes.ItemDescriptor>> newData = ImmutableMap.builder();
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> entry : allData.getData()) {
                newData.put(entry.getKey(), ImmutableMap.copyOf(entry.getValue().getItems()));
            }
            this.allData = newData.build();
            this.initialized = true;
        }
    }

    @Override
    public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        Map<String, DataStoreTypes.ItemDescriptor> items = this.allData.get(kind);
        if (items == null) {
            return null;
        }
        return items.get(key);
    }

    @Override
    public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        Map<String, DataStoreTypes.ItemDescriptor> items = this.allData.get(kind);
        if (items == null) {
            return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(null);
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(ImmutableList.copyOf(items.entrySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        Object object = this.writeLock;
        synchronized (object) {
            Map<String, DataStoreTypes.ItemDescriptor> existingItems = this.allData.get(kind);
            DataStoreTypes.ItemDescriptor oldItem = null;
            if (existingItems != null && (oldItem = existingItems.get(key)) != null && oldItem.getVersion() >= item.getVersion()) {
                return false;
            }
            ImmutableMap.Builder newData = ImmutableMap.builder();
            for (Map.Entry e : this.allData.entrySet()) {
                if (((DataStoreTypes.DataKind)e.getKey()).equals(kind)) continue;
                newData.put(e.getKey(), e.getValue());
            }
            if (existingItems == null) {
                newData.put(kind, ImmutableMap.of(key, item));
            } else {
                ImmutableMap.Builder<String, DataStoreTypes.ItemDescriptor> itemsBuilder = ImmutableMap.builder();
                if (oldItem == null) {
                    itemsBuilder.putAll(existingItems);
                } else {
                    for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e : existingItems.entrySet()) {
                        if (e.getKey().equals(key)) continue;
                        itemsBuilder.put(e.getKey(), e.getValue());
                    }
                }
                itemsBuilder.put(key, item);
                newData.put(kind, itemsBuilder.build());
            }
            this.allData = newData.build();
            return true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public LDValue describeConfiguration(LDConfig config) {
        return LDValue.of("memory");
    }
}

