/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EventUserSerialization;
import com.launchdarkly.sdk.server.EventsConfiguration;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.SerializationException;
import com.launchdarkly.shaded.com.google.gson.Gson;
import com.launchdarkly.shaded.com.google.gson.GsonBuilder;
import com.launchdarkly.shaded.com.google.gson.JsonElement;
import com.launchdarkly.shaded.com.google.gson.JsonParseException;
import com.launchdarkly.shaded.com.google.gson.TypeAdapter;
import com.launchdarkly.shaded.com.google.gson.TypeAdapterFactory;
import com.launchdarkly.shaded.com.google.gson.reflect.TypeToken;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

abstract class JsonHelpers {
    private static final Gson gson = new Gson();

    JsonHelpers() {
    }

    static Gson gsonInstance() {
        return gson;
    }

    static Gson gsonInstanceForEventsSerialization(EventsConfiguration config) {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)LDUser.class), new EventUserSerialization.UserAdapterWithPrivateAttributeBehavior(config)).create();
    }

    static <T> T deserialize(String json, Class<T> objectClass) throws SerializationException {
        try {
            return gson.fromJson(json, objectClass);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    static String serialize(Object o) {
        return gson.toJson(o);
    }

    static DataModel.VersionedData deserializeFromParsedJson(DataStoreTypes.DataKind kind, JsonElement parsedJson) throws SerializationException {
        DataModel.VersionedData item;
        block4: {
            try {
                if (kind == DataModel.FEATURES) {
                    item = gson.fromJson(parsedJson, DataModel.FeatureFlag.class);
                    break block4;
                }
                if (kind == DataModel.SEGMENTS) {
                    item = gson.fromJson(parsedJson, DataModel.Segment.class);
                    break block4;
                }
                throw new IllegalArgumentException("unknown data kind");
            }
            catch (JsonParseException e) {
                throw new SerializationException(e);
            }
        }
        return item;
    }

    private static class PostProcessingDeserializableTypeAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> baseAdapter;

        PostProcessingDeserializableTypeAdapter(TypeAdapter<T> baseAdapter) {
            this.baseAdapter = baseAdapter;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            this.baseAdapter.write(out, value);
        }

        @Override
        public T read(JsonReader in) throws IOException {
            T instance = this.baseAdapter.read(in);
            if (instance instanceof PostProcessingDeserializable) {
                ((PostProcessingDeserializable)instance).afterDeserialized();
            }
            return instance;
        }
    }

    static class PostProcessingDeserializableTypeAdapterFactory
    implements TypeAdapterFactory {
        PostProcessingDeserializableTypeAdapterFactory() {
        }

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return new PostProcessingDeserializableTypeAdapter<T>(gson.getDelegateAdapter(this, type));
        }
    }

    static interface PostProcessingDeserializable {
        public void afterDeserialized();
    }
}

