/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataStoreFactory;
import com.launchdarkly.sdk.server.interfaces.EventProcessorFactory;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.sdk.server.interfaces.HttpConfigurationFactory;
import java.net.URI;
import java.time.Duration;

public final class LDConfig {
    static final URI DEFAULT_BASE_URI = URI.create("https://app.launchdarkly.com");
    static final URI DEFAULT_EVENTS_URI = URI.create("https://events.launchdarkly.com");
    static final URI DEFAULT_STREAM_URI = URI.create("https://stream.launchdarkly.com");
    private static final Duration DEFAULT_START_WAIT = Duration.ofSeconds(5L);
    protected static final LDConfig DEFAULT = new Builder().build();
    final DataSourceFactory dataSourceFactory;
    final DataStoreFactory dataStoreFactory;
    final boolean diagnosticOptOut;
    final EventProcessorFactory eventProcessorFactory;
    final HttpConfiguration httpConfig;
    final boolean offline;
    final Duration startWait;

    protected LDConfig(Builder builder) {
        this.dataStoreFactory = builder.dataStoreFactory;
        this.eventProcessorFactory = builder.eventProcessorFactory;
        this.dataSourceFactory = builder.dataSourceFactory;
        this.diagnosticOptOut = builder.diagnosticOptOut;
        this.httpConfig = builder.httpConfigFactory == null ? Components.httpConfiguration().createHttpConfiguration() : builder.httpConfigFactory.createHttpConfiguration();
        this.offline = builder.offline;
        this.startWait = builder.startWait;
    }

    LDConfig(LDConfig config) {
        this.dataSourceFactory = config.dataSourceFactory;
        this.dataStoreFactory = config.dataStoreFactory;
        this.diagnosticOptOut = config.diagnosticOptOut;
        this.eventProcessorFactory = config.eventProcessorFactory;
        this.httpConfig = config.httpConfig;
        this.offline = config.offline;
        this.startWait = config.startWait;
    }

    public static class Builder {
        private DataSourceFactory dataSourceFactory = null;
        private DataStoreFactory dataStoreFactory = null;
        private boolean diagnosticOptOut = false;
        private EventProcessorFactory eventProcessorFactory = null;
        private HttpConfigurationFactory httpConfigFactory = null;
        private boolean offline = false;
        private Duration startWait = LDConfig.access$700();

        public Builder dataSource(DataSourceFactory factory) {
            this.dataSourceFactory = factory;
            return this;
        }

        public Builder dataStore(DataStoreFactory factory) {
            this.dataStoreFactory = factory;
            return this;
        }

        public Builder diagnosticOptOut(boolean diagnosticOptOut) {
            this.diagnosticOptOut = diagnosticOptOut;
            return this;
        }

        public Builder events(EventProcessorFactory factory) {
            this.eventProcessorFactory = factory;
            return this;
        }

        public Builder http(HttpConfigurationFactory factory) {
            this.httpConfigFactory = factory;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder startWait(Duration startWait) {
            this.startWait = startWait == null ? DEFAULT_START_WAIT : startWait;
            return this;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

