/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.FeatureRequestor;
import com.launchdarkly.sdk.server.HttpErrorException;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataStoreUpdates;
import com.launchdarkly.sdk.server.interfaces.SerializationException;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PollingProcessor
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(PollingProcessor.class);
    @VisibleForTesting
    final FeatureRequestor requestor;
    private final DataStoreUpdates dataStoreUpdates;
    @VisibleForTesting
    final Duration pollInterval;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private ScheduledExecutorService scheduler = null;

    PollingProcessor(FeatureRequestor requestor, DataStoreUpdates dataStoreUpdates, Duration pollInterval) {
        this.requestor = requestor;
        this.dataStoreUpdates = dataStoreUpdates;
        this.pollInterval = pollInterval;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly PollingProcessor");
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.requestor.close();
    }

    @Override
    public Future<Void> start() {
        logger.info("Starting LaunchDarkly polling client with interval: " + this.pollInterval.toMillis() + " milliseconds");
        CompletableFuture<Void> initFuture = new CompletableFuture<Void>();
        ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setNameFormat("LaunchDarkly-PollingProcessor-%d").build();
        this.scheduler = Executors.newScheduledThreadPool(1, threadFactory2);
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                FeatureRequestor.AllData allData = this.requestor.getAllData();
                this.dataStoreUpdates.init(allData.toFullDataSet());
                if (!this.initialized.getAndSet(true)) {
                    logger.info("Initialized LaunchDarkly client.");
                    initFuture.complete(null);
                }
            }
            catch (HttpErrorException e) {
                logger.error(Util.httpErrorMessage(e.getStatus(), "polling request", "will retry"));
                if (!Util.isHttpErrorRecoverable(e.getStatus())) {
                    this.scheduler.shutdown();
                    initFuture.complete(null);
                }
            }
            catch (IOException e) {
                logger.error("Encountered exception in LaunchDarkly client when retrieving update: {}", (Object)e.toString());
                logger.debug(e.toString(), (Throwable)e);
            }
            catch (SerializationException e) {
                logger.error("Polling request received malformed data: {}", (Object)e.toString());
            }
        }, 0L, this.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
        return initFuture;
    }
}

