/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SemanticVersion
implements Comparable<SemanticVersion> {
    private static Pattern VERSION_REGEX = Pattern.compile("^(?<major>0|[1-9]\\d*)(\\.(?<minor>0|[1-9]\\d*))?(\\.(?<patch>0|[1-9]\\d*))?(\\-(?<prerel>[0-9A-Za-z\\-\\.]+))?(\\+(?<build>[0-9A-Za-z\\-\\.]+))?$");
    private final int major;
    private final int minor;
    private final int patch;
    private final String prerelease;
    private final String build;

    public SemanticVersion(int major, int minor, int patch, String prerelease, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getPrerelease() {
        return this.prerelease;
    }

    public String getBuild() {
        return this.build;
    }

    public static SemanticVersion parse(String input) throws InvalidVersionException {
        return SemanticVersion.parse(input, false);
    }

    public static SemanticVersion parse(String input, boolean allowMissingMinorAndPatch) throws InvalidVersionException {
        int patch;
        int minor;
        int major;
        Matcher matcher = VERSION_REGEX.matcher(input);
        if (!matcher.matches()) {
            throw new InvalidVersionException("Invalid semantic version");
        }
        try {
            major = Integer.parseInt(matcher.group("major"));
            if (!(allowMissingMinorAndPatch || matcher.group("minor") != null && matcher.group("patch") != null)) {
                throw new InvalidVersionException("Invalid semantic version");
            }
            minor = matcher.group("minor") == null ? 0 : Integer.parseInt(matcher.group("minor"));
            patch = matcher.group("patch") == null ? 0 : Integer.parseInt(matcher.group("patch"));
        }
        catch (NumberFormatException e) {
            throw new InvalidVersionException("Invalid semantic version");
        }
        String prerelease = matcher.group("prerel");
        String build = matcher.group("build");
        return new SemanticVersion(major, minor, patch, prerelease, build);
    }

    @Override
    public int compareTo(SemanticVersion other) {
        return this.comparePrecedence(other);
    }

    public int comparePrecedence(SemanticVersion other) {
        if (other == null) {
            return 1;
        }
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        if (this.patch != other.patch) {
            return Integer.compare(this.patch, other.patch);
        }
        if (this.prerelease == null && other.prerelease == null) {
            return 0;
        }
        if (this.prerelease == null) {
            return 1;
        }
        if (other.prerelease == null) {
            return -1;
        }
        return this.compareIdentifiers(this.prerelease.split("\\."), other.prerelease.split("\\."));
    }

    private int compareIdentifiers(String[] ids1, String[] ids2) {
        int i = 0;
        while (i < ids1.length) {
            int d;
            boolean isNum2;
            boolean isNum1;
            if (i >= ids2.length) {
                return 1;
            }
            int n1 = 0;
            int n2 = 0;
            try {
                n1 = Integer.parseInt(ids1[i]);
                isNum1 = true;
            }
            catch (NumberFormatException e) {
                isNum1 = false;
            }
            try {
                n2 = Integer.parseInt(ids2[i]);
                isNum2 = true;
            }
            catch (NumberFormatException e) {
                isNum2 = false;
            }
            if (isNum1 && isNum2) {
                d = Integer.compare(n1, n2);
            } else {
                int n = isNum1 ? -1 : (d = isNum2 ? 1 : ids1[i].compareTo(ids2[i]));
            }
            if (d != 0) {
                return d;
            }
            ++i;
        }
        return i >= ids2.length ? 0 : -1;
    }

    public static class InvalidVersionException
    extends Exception {
        public InvalidVersionException(String message) {
            super(message);
        }
    }
}

