/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.UserAttribute;
import com.launchdarkly.sdk.server.interfaces.EventProcessorFactory;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class EventProcessorBuilder
implements EventProcessorFactory {
    public static final int DEFAULT_CAPACITY = 10000;
    public static final Duration DEFAULT_DIAGNOSTIC_RECORDING_INTERVAL = Duration.ofMinutes(15L);
    public static final Duration DEFAULT_FLUSH_INTERVAL = Duration.ofSeconds(5L);
    public static final int DEFAULT_USER_KEYS_CAPACITY = 1000;
    public static final Duration DEFAULT_USER_KEYS_FLUSH_INTERVAL = Duration.ofMinutes(5L);
    public static final Duration MIN_DIAGNOSTIC_RECORDING_INTERVAL = Duration.ofSeconds(60L);
    protected boolean allAttributesPrivate = false;
    protected URI baseURI;
    protected int capacity = 10000;
    protected Duration diagnosticRecordingInterval = DEFAULT_DIAGNOSTIC_RECORDING_INTERVAL;
    protected Duration flushInterval = DEFAULT_FLUSH_INTERVAL;
    protected boolean inlineUsersInEvents = false;
    protected Set<UserAttribute> privateAttributes;
    protected int userKeysCapacity = 1000;
    protected Duration userKeysFlushInterval = DEFAULT_USER_KEYS_FLUSH_INTERVAL;

    public EventProcessorBuilder allAttributesPrivate(boolean allAttributesPrivate) {
        this.allAttributesPrivate = allAttributesPrivate;
        return this;
    }

    public EventProcessorBuilder baseURI(URI baseURI) {
        this.baseURI = baseURI;
        return this;
    }

    public EventProcessorBuilder capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public EventProcessorBuilder diagnosticRecordingInterval(Duration diagnosticRecordingInterval) {
        this.diagnosticRecordingInterval = diagnosticRecordingInterval == null ? DEFAULT_DIAGNOSTIC_RECORDING_INTERVAL : (diagnosticRecordingInterval.compareTo(MIN_DIAGNOSTIC_RECORDING_INTERVAL) < 0 ? MIN_DIAGNOSTIC_RECORDING_INTERVAL : diagnosticRecordingInterval);
        return this;
    }

    public EventProcessorBuilder flushInterval(Duration flushInterval) {
        this.flushInterval = flushInterval == null ? DEFAULT_FLUSH_INTERVAL : flushInterval;
        return this;
    }

    public EventProcessorBuilder inlineUsersInEvents(boolean inlineUsersInEvents) {
        this.inlineUsersInEvents = inlineUsersInEvents;
        return this;
    }

    public EventProcessorBuilder privateAttributeNames(String ... attributeNames) {
        this.privateAttributes = new HashSet<UserAttribute>();
        for (String a : attributeNames) {
            this.privateAttributes.add(UserAttribute.forName(a));
        }
        return this;
    }

    public EventProcessorBuilder privateAttributes(UserAttribute ... attributes) {
        this.privateAttributes = new HashSet<UserAttribute>(Arrays.asList(attributes));
        return this;
    }

    public EventProcessorBuilder userKeysCapacity(int userKeysCapacity) {
        this.userKeysCapacity = userKeysCapacity;
        return this;
    }

    public EventProcessorBuilder userKeysFlushInterval(Duration userKeysFlushInterval) {
        this.userKeysFlushInterval = userKeysFlushInterval == null ? DEFAULT_USER_KEYS_FLUSH_INTERVAL : userKeysFlushInterval;
        return this;
    }
}

