/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.integrations.FileDataSourceImpl;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataStoreUpdates;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public final class FileDataSourceBuilder
implements DataSourceFactory {
    private final List<Path> sources = new ArrayList<Path>();
    private boolean autoUpdate = false;

    public FileDataSourceBuilder filePaths(String ... filePaths) throws InvalidPathException {
        for (String p : filePaths) {
            this.sources.add(Paths.get(p, new String[0]));
        }
        return this;
    }

    public FileDataSourceBuilder filePaths(Path ... filePaths) {
        for (Path p : filePaths) {
            this.sources.add(p);
        }
        return this;
    }

    public FileDataSourceBuilder autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    @Override
    public DataSource createDataSource(ClientContext context, DataStoreUpdates dataStoreUpdates) {
        return new FileDataSourceImpl(dataStoreUpdates, this.sources, this.autoUpdate);
    }
}

