/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.integrations.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreFactory;
import com.launchdarkly.sdk.server.interfaces.PersistentDataStore;
import com.launchdarkly.sdk.server.interfaces.PersistentDataStoreFactory;
import java.time.Duration;

public abstract class PersistentDataStoreBuilder
implements DataStoreFactory {
    public static final Duration DEFAULT_CACHE_TTL = Duration.ofSeconds(15L);
    protected final PersistentDataStoreFactory persistentDataStoreFactory;
    private Duration cacheTime = DEFAULT_CACHE_TTL;
    private StaleValuesPolicy staleValuesPolicy = StaleValuesPolicy.EVICT;
    private boolean recordCacheStats = false;

    protected PersistentDataStoreBuilder(PersistentDataStoreFactory persistentDataStoreFactory) {
        this.persistentDataStoreFactory = persistentDataStoreFactory;
    }

    public PersistentDataStoreBuilder noCaching() {
        return this.cacheTime(Duration.ZERO);
    }

    public PersistentDataStoreBuilder cacheTime(Duration cacheTime) {
        this.cacheTime = cacheTime == null ? DEFAULT_CACHE_TTL : cacheTime;
        return this;
    }

    public PersistentDataStoreBuilder cacheMillis(long millis) {
        return this.cacheTime(Duration.ofMillis(millis));
    }

    public PersistentDataStoreBuilder cacheSeconds(long seconds) {
        return this.cacheTime(Duration.ofSeconds(seconds));
    }

    public PersistentDataStoreBuilder cacheForever() {
        return this.cacheTime(Duration.ofMillis(-1L));
    }

    public PersistentDataStoreBuilder staleValuesPolicy(StaleValuesPolicy staleValuesPolicy) {
        this.staleValuesPolicy = staleValuesPolicy == null ? StaleValuesPolicy.EVICT : staleValuesPolicy;
        return this;
    }

    public PersistentDataStoreBuilder recordCacheStats(boolean recordCacheStats) {
        this.recordCacheStats = recordCacheStats;
        return this;
    }

    @Override
    public DataStore createDataStore(ClientContext context) {
        PersistentDataStore core = this.persistentDataStoreFactory.createPersistentDataStore(context);
        return new PersistentDataStoreWrapper(core, this.cacheTime, this.staleValuesPolicy, this.recordCacheStats);
    }

    public static enum StaleValuesPolicy {
        EVICT,
        REFRESH,
        REFRESH_ASYNC;

    }
}

