/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PersistentDataStoreStatusManager {
    private static final Logger logger = LoggerFactory.getLogger(PersistentDataStoreStatusManager.class);
    static final int POLL_INTERVAL_MS = 500;
    private final List<DataStoreStatusProvider.StatusListener> listeners = new ArrayList<DataStoreStatusProvider.StatusListener>();
    private final ScheduledExecutorService scheduler;
    private final Callable<Boolean> statusPollFn;
    private final boolean refreshOnRecovery;
    private volatile boolean lastAvailable;
    private volatile ScheduledFuture<?> pollerFuture;

    PersistentDataStoreStatusManager(boolean refreshOnRecovery, boolean availableNow, Callable<Boolean> statusPollFn) {
        this.refreshOnRecovery = refreshOnRecovery;
        this.lastAvailable = availableNow;
        this.statusPollFn = statusPollFn;
        ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setNameFormat("LaunchDarkly-DataStoreStatusManager-%d").build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory2);
    }

    synchronized void addStatusListener(DataStoreStatusProvider.StatusListener listener) {
        this.listeners.add(listener);
    }

    synchronized void removeStatusListener(DataStoreStatusProvider.StatusListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAvailability(boolean available) {
        DataStoreStatusProvider.StatusListener[] copyOfListeners = null;
        PersistentDataStoreStatusManager persistentDataStoreStatusManager = this;
        synchronized (persistentDataStoreStatusManager) {
            if (this.lastAvailable == available) {
                return;
            }
            this.lastAvailable = available;
            copyOfListeners = this.listeners.toArray(new DataStoreStatusProvider.StatusListener[this.listeners.size()]);
        }
        DataStoreStatusProvider.Status status = new DataStoreStatusProvider.Status(available, available && this.refreshOnRecovery);
        if (available) {
            logger.warn("Persistent store is available again");
        }
        if (copyOfListeners.length > 0) {
            this.scheduler.schedule(new StatusNotificationTask(status, copyOfListeners), 0L, TimeUnit.MILLISECONDS);
        }
        if (available) {
            PersistentDataStoreStatusManager persistentDataStoreStatusManager2 = this;
            synchronized (persistentDataStoreStatusManager2) {
                if (this.pollerFuture != null) {
                    this.pollerFuture.cancel(false);
                    this.pollerFuture = null;
                }
            }
        }
        logger.warn("Detected persistent store unavailability; updates will be cached until it recovers");
        Runnable pollerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (((Boolean)PersistentDataStoreStatusManager.this.statusPollFn.call()).booleanValue()) {
                        PersistentDataStoreStatusManager.this.updateAvailability(true);
                    }
                }
                catch (Exception e) {
                    logger.error("Unexpected error from data store status function: {0}", (Throwable)e);
                }
            }
        };
        PersistentDataStoreStatusManager persistentDataStoreStatusManager3 = this;
        synchronized (persistentDataStoreStatusManager3) {
            if (this.pollerFuture == null) {
                this.pollerFuture = this.scheduler.scheduleAtFixedRate(pollerTask, 500L, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    synchronized boolean isAvailable() {
        return this.lastAvailable;
    }

    void close() {
        this.scheduler.shutdown();
    }

    private static final class StatusNotificationTask
    implements Runnable {
        private final DataStoreStatusProvider.Status status;
        private final DataStoreStatusProvider.StatusListener[] listeners;

        StatusNotificationTask(DataStoreStatusProvider.Status status, DataStoreStatusProvider.StatusListener[] listeners) {
            this.status = status;
            this.listeners = listeners;
        }

        @Override
        public void run() {
            for (DataStoreStatusProvider.StatusListener listener : this.listeners) {
                try {
                    listener.dataStoreStatusChanged(this.status);
                }
                catch (Exception e) {
                    logger.error("Unexpected error from StatusListener: {0}", (Throwable)e);
                }
            }
        }
    }
}

