/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import com.launchdarkly.shaded.com.launchdarkly.eventsource.AsyncEventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ConnectionErrorHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ModernTLSSocketFactory;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.UnsuccessfulResponseException;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.Call;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.HttpUrl;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.RequestBody;
import com.launchdarkly.shaded.okhttp3.Response;
import com.launchdarkly.shaded.okio.BufferedSource;
import com.launchdarkly.shaded.okio.Okio;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSource
implements Closeable {
    private final Logger logger;
    public static final Duration DEFAULT_RECONNECT_TIME = Duration.ofSeconds(1L);
    public static final Duration DEFAULT_MAX_RECONNECT_TIME = Duration.ofSeconds(30L);
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(5L);
    public static final Duration DEFAULT_BACKOFF_RESET_THRESHOLD = Duration.ofSeconds(60L);
    private static final Headers defaultHeaders = new Headers.Builder().add("Accept", "text/event-stream").add("Cache-Control", "no-cache").build();
    private final String name;
    private volatile HttpUrl url;
    private final Headers headers;
    private final String method;
    private final RequestBody body;
    private final RequestTransformer requestTransformer;
    private final ExecutorService eventExecutor;
    private final ExecutorService streamExecutor;
    private Duration reconnectTime;
    private Duration maxReconnectTime;
    private final Duration backoffResetThreshold;
    private volatile String lastEventId;
    private final EventHandler handler;
    private final ConnectionErrorHandler connectionErrorHandler;
    private final AtomicReference<ReadyState> readyState;
    private final OkHttpClient client;
    private volatile Call call;
    private final Random jitter = new Random();
    private Response response;
    private BufferedSource bufferedSource;

    EventSource(Builder builder) {
        this.name = builder.name;
        String loggerName = EventSource.class.getCanonicalName() + (this.name == null || this.name.equals("") ? "" : "." + this.name);
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.url = builder.url;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.method = builder.method;
        this.body = builder.body;
        this.requestTransformer = builder.requestTransformer;
        this.lastEventId = builder.lastEventId;
        this.reconnectTime = builder.reconnectTime;
        this.maxReconnectTime = builder.maxReconnectTime;
        this.backoffResetThreshold = builder.backoffResetThreshold;
        ThreadFactory eventsThreadFactory = this.createThreadFactory("okhttp-eventsource-events");
        this.eventExecutor = Executors.newSingleThreadExecutor(eventsThreadFactory);
        ThreadFactory streamThreadFactory = this.createThreadFactory("okhttp-eventsource-stream");
        this.streamExecutor = Executors.newSingleThreadExecutor(streamThreadFactory);
        this.handler = new AsyncEventHandler(this.eventExecutor, builder.handler);
        this.connectionErrorHandler = builder.connectionErrorHandler;
        this.readyState = new AtomicReference<ReadyState>(ReadyState.RAW);
        this.client = builder.clientBuilder.build();
    }

    private ThreadFactory createThreadFactory(String type) {
        ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        AtomicLong count = new AtomicLong(0L);
        return runnable2 -> {
            Thread thread2 = backingThreadFactory.newThread(runnable2);
            thread2.setName(String.format(Locale.ROOT, "%s-[%s]-%d", type, this.name, count.getAndIncrement()));
            thread2.setDaemon(true);
            return thread2;
        };
    }

    public void start() {
        if (!this.readyState.compareAndSet(ReadyState.RAW, ReadyState.CONNECTING)) {
            this.logger.info("Start method called on this already-started EventSource object. Doing nothing");
            return;
        }
        this.logger.debug("readyState change: " + (Object)((Object)ReadyState.RAW) + " -> " + (Object)((Object)ReadyState.CONNECTING));
        this.logger.info("Starting EventSource client using URI: " + this.url);
        this.streamExecutor.execute(this::connect);
    }

    public void restart() {
        ReadyState previousState = this.readyState.getAndUpdate(t -> t == ReadyState.OPEN ? ReadyState.CLOSED : t);
        if (previousState == ReadyState.OPEN) {
            this.closeCurrentStream(previousState);
        } else if (previousState == ReadyState.RAW || previousState == ReadyState.CONNECTING) {
            this.start();
        }
    }

    public ReadyState getState() {
        return this.readyState.get();
    }

    @Override
    public void close() {
        ReadyState currentState = this.readyState.getAndSet(ReadyState.SHUTDOWN);
        this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.SHUTDOWN));
        if (currentState == ReadyState.SHUTDOWN) {
            return;
        }
        this.closeCurrentStream(currentState);
        this.eventExecutor.shutdownNow();
        this.streamExecutor.shutdownNow();
        if (this.client != null) {
            if (this.client.connectionPool() != null) {
                this.client.connectionPool().evictAll();
            }
            if (this.client.dispatcher() != null) {
                this.client.dispatcher().cancelAll();
                if (this.client.dispatcher().executorService() != null) {
                    this.client.dispatcher().executorService().shutdownNow();
                }
            }
        }
    }

    private void closeCurrentStream(ReadyState previousState) {
        if (previousState == ReadyState.OPEN) {
            try {
                this.handler.onClosed();
            }
            catch (Exception e) {
                this.handler.onError(e);
            }
        }
        if (this.call != null) {
            this.call.cancel();
            this.logger.debug("call cancelled");
        }
    }

    Request buildRequest() {
        Request.Builder builder = new Request.Builder().headers(this.headers).url(this.url).method(this.method, this.body);
        if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
            builder.addHeader("Last-Event-ID", this.lastEventId);
        }
        Request request = builder.build();
        return this.requestTransformer == null ? request : this.requestTransformer.transformRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void connect() {
        this.response = null;
        this.bufferedSource = null;
        int reconnectAttempts = 0;
        ConnectionErrorHandler.Action errorHandlerAction = null;
        ConnectionHandler connectionHandler = new ConnectionHandler(){

            @Override
            public void setReconnectionTime(Duration reconnectionTime) {
                EventSource.this.setReconnectionTime(reconnectionTime);
            }

            @Override
            public void setLastEventId(String lastEventId) {
                EventSource.this.setLastEventId(lastEventId);
            }
        };
        try {
            block27: while (!Thread.currentThread().isInterrupted()) {
                if (this.readyState.get() == ReadyState.SHUTDOWN) return;
                long connectedTime = -1L;
                ReadyState currentState = this.readyState.getAndSet(ReadyState.CONNECTING);
                this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.CONNECTING));
                try {
                    this.call = this.client.newCall(this.buildRequest());
                    this.response = this.call.execute();
                    if (this.response.isSuccessful()) {
                        connectedTime = System.currentTimeMillis();
                        currentState = this.readyState.getAndSet(ReadyState.OPEN);
                        if (currentState != ReadyState.CONNECTING) {
                            this.logger.warn("Unexpected readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        } else {
                            this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        }
                        this.logger.info("Connected to Event Source stream.");
                        try {
                            this.handler.onOpen();
                        }
                        catch (Exception e) {
                            this.handler.onError(e);
                        }
                        if (this.bufferedSource != null) {
                            this.bufferedSource.close();
                        }
                        this.bufferedSource = Okio.buffer(this.response.body().source());
                        EventParser parser = new EventParser(this.url.uri(), this.handler, connectionHandler);
                        while (true) {
                            String line;
                            if (Thread.currentThread().isInterrupted() || (line = this.bufferedSource.readUtf8LineStrict()) == null) continue block27;
                            parser.line(line);
                        }
                    }
                    this.logger.debug("Unsuccessful Response: " + this.response);
                    errorHandlerAction = this.dispatchError(new UnsuccessfulResponseException(this.response.code()));
                }
                catch (EOFException eofe) {
                    this.logger.warn("Connection unexpectedly closed.");
                }
                catch (IOException ioe) {
                    ReadyState state = this.readyState.get();
                    if (state == ReadyState.SHUTDOWN) {
                        errorHandlerAction = ConnectionErrorHandler.Action.SHUTDOWN;
                        continue;
                    }
                    if (state == ReadyState.CLOSED) {
                        errorHandlerAction = ConnectionErrorHandler.Action.PROCEED;
                        continue;
                    }
                    this.logger.debug("Connection problem.", (Throwable)ioe);
                    errorHandlerAction = this.dispatchError(ioe);
                }
                finally {
                    ReadyState nextState = ReadyState.CLOSED;
                    if (errorHandlerAction == ConnectionErrorHandler.Action.SHUTDOWN) {
                        this.logger.info("Connection has been explicitly shut down by error handler");
                        nextState = ReadyState.SHUTDOWN;
                    }
                    currentState = this.readyState.getAndSet(nextState);
                    this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)nextState));
                    if (this.response != null && this.response.body() != null) {
                        this.response.close();
                        this.logger.debug("response closed");
                    }
                    if (this.bufferedSource != null) {
                        try {
                            this.bufferedSource.close();
                            this.logger.debug("buffered source closed");
                        }
                        catch (IOException e) {
                            this.logger.warn("Exception when closing bufferedSource", (Throwable)e);
                        }
                    }
                    if (currentState == ReadyState.OPEN) {
                        try {
                            this.handler.onClosed();
                        }
                        catch (Exception e) {
                            this.handler.onError(e);
                        }
                    }
                    if (connectedTime >= 0L && System.currentTimeMillis() - connectedTime >= this.backoffResetThreshold.toMillis()) {
                        reconnectAttempts = 0;
                    }
                    this.maybeWaitWithBackoff(++reconnectAttempts);
                }
            }
            return;
        }
        catch (RejectedExecutionException ignored) {
            this.call = null;
            this.response = null;
            this.bufferedSource = null;
            this.logger.debug("Rejected execution exception ignored: ", (Throwable)ignored);
        }
    }

    private ConnectionErrorHandler.Action dispatchError(Throwable t) {
        ConnectionErrorHandler.Action action = this.connectionErrorHandler.onConnectionError(t);
        if (action != ConnectionErrorHandler.Action.SHUTDOWN) {
            this.handler.onError(t);
        }
        return action;
    }

    private void maybeWaitWithBackoff(int reconnectAttempts) {
        if (!this.reconnectTime.isZero() && !this.reconnectTime.isNegative() && reconnectAttempts > 0) {
            try {
                Duration sleepTime = this.backoffWithJitter(reconnectAttempts);
                this.logger.info("Waiting " + sleepTime.toMillis() + " milliseconds before reconnecting...");
                Thread.sleep(sleepTime.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    Duration backoffWithJitter(int reconnectAttempts) {
        long jitterVal = Math.min(this.maxReconnectTime.toMillis(), this.reconnectTime.toMillis() * (long)this.pow2(reconnectAttempts));
        return Duration.ofMillis(jitterVal / 2L + this.nextLong(this.jitter, jitterVal) / 2L);
    }

    private int pow2(int k) {
        return k < 31 ? 1 << k : Integer.MAX_VALUE;
    }

    private long nextLong(Random rand, long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long r = rand.nextLong() & Long.MAX_VALUE;
        long m3 = bound - 1L;
        if ((bound & m3) == 0L) {
            r = bound * r >> 63;
        } else {
            long u = r;
            while (u - (r = u % bound) + m3 < 0L) {
                u = rand.nextLong() & Long.MAX_VALUE;
            }
        }
        return r;
    }

    private static Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        for (String name : defaultHeaders.names()) {
            if (custom.names().contains(name)) continue;
            for (String value : defaultHeaders.values(name)) {
                builder.add(name, value);
            }
        }
        for (String name : custom.names()) {
            for (String value : custom.values(name)) {
                builder.add(name, value);
            }
        }
        return builder.build();
    }

    private void setReconnectionTime(Duration reconnectionTime) {
        this.reconnectTime = reconnectionTime == null ? DEFAULT_RECONNECT_TIME : reconnectionTime;
    }

    private void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public String getLastEventId() {
        return this.lastEventId;
    }

    public HttpUrl getHttpUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.url.uri();
    }

    public static final class Builder {
        private String name = "";
        private Duration reconnectTime = DEFAULT_RECONNECT_TIME;
        private Duration maxReconnectTime = DEFAULT_MAX_RECONNECT_TIME;
        private Duration backoffResetThreshold = DEFAULT_BACKOFF_RESET_THRESHOLD;
        private String lastEventId;
        private final HttpUrl url;
        private final EventHandler handler;
        private ConnectionErrorHandler connectionErrorHandler = ConnectionErrorHandler.DEFAULT;
        private Headers headers = Headers.of(new String[0]);
        private Proxy proxy;
        private Authenticator proxyAuthenticator = null;
        private String method = "GET";
        private RequestTransformer requestTransformer = null;
        private RequestBody body = null;
        private OkHttpClient.Builder clientBuilder;

        public Builder(EventHandler handler, URI uri) {
            this(handler, uri == null ? null : HttpUrl.get(uri));
        }

        public Builder(EventHandler handler, HttpUrl url) {
            if (handler == null) {
                throw new IllegalArgumentException("handler must not be null");
            }
            if (url == null) {
                throw new IllegalArgumentException("URI/URL must not be null");
            }
            this.url = url;
            this.handler = handler;
            this.clientBuilder = Builder.createInitialClientBuilder();
        }

        private static OkHttpClient.Builder createInitialClientBuilder() {
            OkHttpClient.Builder b = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 1L, TimeUnit.SECONDS)).connectTimeout(DEFAULT_CONNECT_TIMEOUT).readTimeout(DEFAULT_READ_TIMEOUT).writeTimeout(DEFAULT_WRITE_TIMEOUT).retryOnConnectionFailure(true);
            try {
                b.sslSocketFactory(new ModernTLSSocketFactory(), Builder.defaultTrustManager());
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            return b;
        }

        public Builder method(String method) {
            if (method != null && method.length() > 0) {
                this.method = method.toUpperCase();
            }
            return this;
        }

        public Builder body(RequestBody body) {
            this.body = body;
            return this;
        }

        public Builder requestTransformer(RequestTransformer requestTransformer) {
            this.requestTransformer = requestTransformer;
            return this;
        }

        public Builder name(String name) {
            if (name != null) {
                this.name = name;
            }
            return this;
        }

        public Builder lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return this;
        }

        public Builder reconnectTime(Duration reconnectTime) {
            this.reconnectTime = reconnectTime == null ? DEFAULT_RECONNECT_TIME : reconnectTime;
            return this;
        }

        public Builder maxReconnectTime(Duration maxReconnectTime) {
            this.maxReconnectTime = maxReconnectTime == null ? DEFAULT_MAX_RECONNECT_TIME : maxReconnectTime;
            return this;
        }

        public Builder backoffResetThreshold(Duration backoffResetThreshold) {
            this.backoffResetThreshold = backoffResetThreshold == null ? DEFAULT_BACKOFF_RESET_THRESHOLD : backoffResetThreshold;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.clientBuilder = client.newBuilder();
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.clientBuilder.connectTimeout(connectTimeout == null ? DEFAULT_CONNECT_TIMEOUT : connectTimeout);
            return this;
        }

        public Builder writeTimeout(Duration writeTimeout) {
            this.clientBuilder.writeTimeout(writeTimeout == null ? DEFAULT_WRITE_TIMEOUT : writeTimeout);
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.clientBuilder.readTimeout(readTimeout == null ? DEFAULT_READ_TIMEOUT : readTimeout);
            return this;
        }

        public Builder connectionErrorHandler(ConnectionErrorHandler handler) {
            if (handler != null) {
                this.connectionErrorHandler = handler;
            }
            return this;
        }

        public Builder clientBuilderActions(ClientConfigurer configurer) {
            configurer.configure(this.clientBuilder);
            return this;
        }

        public EventSource build() {
            if (this.proxy != null) {
                this.clientBuilder.proxy(this.proxy);
            }
            if (this.proxyAuthenticator != null) {
                this.clientBuilder.proxyAuthenticator(this.proxyAuthenticator);
            }
            return new EventSource(this);
        }

        protected OkHttpClient.Builder getClientBuilder() {
            return this.clientBuilder;
        }

        private static X509TrustManager defaultTrustManager() throws GeneralSecurityException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }

        public static interface ClientConfigurer {
            public void configure(OkHttpClient.Builder var1);
        }
    }

    public static interface RequestTransformer {
        public Request transformRequest(Request var1);
    }
}

