/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DiagnosticAccumulator;
import com.launchdarkly.sdk.server.DiagnosticEvent;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.sdk.server.interfaces.LoggingConfiguration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

final class ClientContextImpl
implements ClientContext {
    private static volatile ScheduledExecutorService fallbackSharedExecutor = null;
    private final String sdkKey;
    private final HttpConfiguration httpConfiguration;
    private final LoggingConfiguration loggingConfiguration;
    private final boolean offline;
    private final int threadPriority;
    final ScheduledExecutorService sharedExecutor;
    final DiagnosticAccumulator diagnosticAccumulator;
    final DiagnosticEvent.Init diagnosticInitEvent;

    private ClientContextImpl(String sdkKey, HttpConfiguration httpConfiguration, LoggingConfiguration loggingConfiguration, boolean offline, int threadPriority, ScheduledExecutorService sharedExecutor, DiagnosticAccumulator diagnosticAccumulator, DiagnosticEvent.Init diagnosticInitEvent) {
        this.sdkKey = sdkKey;
        this.httpConfiguration = httpConfiguration;
        this.loggingConfiguration = loggingConfiguration;
        this.offline = offline;
        this.threadPriority = threadPriority;
        this.sharedExecutor = sharedExecutor;
        this.diagnosticAccumulator = diagnosticAccumulator;
        this.diagnosticInitEvent = diagnosticInitEvent;
    }

    ClientContextImpl(String sdkKey, LDConfig configuration, ScheduledExecutorService sharedExecutor, DiagnosticAccumulator diagnosticAccumulator) {
        this.sdkKey = sdkKey;
        this.httpConfiguration = configuration.httpConfig;
        this.loggingConfiguration = configuration.loggingConfig;
        this.offline = configuration.offline;
        this.threadPriority = configuration.threadPriority;
        this.sharedExecutor = sharedExecutor;
        if (!configuration.diagnosticOptOut && diagnosticAccumulator != null) {
            this.diagnosticAccumulator = diagnosticAccumulator;
            this.diagnosticInitEvent = new DiagnosticEvent.Init(diagnosticAccumulator.dataSinceDate, diagnosticAccumulator.diagnosticId, configuration);
        } else {
            this.diagnosticAccumulator = null;
            this.diagnosticInitEvent = null;
        }
    }

    @Override
    public String getSdkKey() {
        return this.sdkKey;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    @Override
    public LoggingConfiguration getLoggingConfiguration() {
        return this.loggingConfiguration;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClientContextImpl get(ClientContext context) {
        if (context instanceof ClientContextImpl) {
            return (ClientContextImpl)context;
        }
        Class<ClientContextImpl> clazz = ClientContextImpl.class;
        synchronized (ClientContextImpl.class) {
            if (fallbackSharedExecutor == null) {
                fallbackSharedExecutor = Executors.newSingleThreadScheduledExecutor();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new ClientContextImpl(context.getSdkKey(), context.getHttpConfiguration(), context.getLoggingConfiguration(), context.isOffline(), context.getThreadPriority(), fallbackSharedExecutor, null, null);
        }
    }
}

