/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.DefaultEventProcessor;
import com.launchdarkly.sdk.server.DefaultEventSender;
import com.launchdarkly.sdk.server.DefaultFeatureRequestor;
import com.launchdarkly.sdk.server.DiagnosticEvent;
import com.launchdarkly.sdk.server.EventsConfiguration;
import com.launchdarkly.sdk.server.FlagValueMonitoringListener;
import com.launchdarkly.sdk.server.HttpConfigurationImpl;
import com.launchdarkly.sdk.server.InMemoryDataStore;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDClientInterface;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.LoggingConfigurationImpl;
import com.launchdarkly.sdk.server.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.server.PollingProcessor;
import com.launchdarkly.sdk.server.StreamProcessor;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.LoggingConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.StreamingDataSourceBuilder;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceUpdates;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreFactory;
import com.launchdarkly.sdk.server.interfaces.DataStoreUpdates;
import com.launchdarkly.sdk.server.interfaces.DiagnosticDescription;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.sdk.server.interfaces.EventProcessor;
import com.launchdarkly.sdk.server.interfaces.EventProcessorFactory;
import com.launchdarkly.sdk.server.interfaces.EventSender;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeListener;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.sdk.server.interfaces.LoggingConfiguration;
import com.launchdarkly.sdk.server.interfaces.PersistentDataStore;
import com.launchdarkly.sdk.server.interfaces.PersistentDataStoreFactory;
import com.launchdarkly.shaded.okhttp3.Credentials;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public abstract class Components {
    private static final EventProcessorFactory NULL_EVENT_PROCESSOR_FACTORY = context -> NullEventProcessor.INSTANCE;

    public static DataStoreFactory inMemoryDataStore() {
        return InMemoryDataStoreFactory.INSTANCE;
    }

    public static PersistentDataStoreBuilder persistentDataStore(PersistentDataStoreFactory storeFactory) {
        return new PersistentDataStoreBuilderImpl(storeFactory);
    }

    public static EventProcessorBuilder sendEvents() {
        return new EventProcessorBuilderImpl();
    }

    public static EventProcessorFactory noEvents() {
        return NULL_EVENT_PROCESSOR_FACTORY;
    }

    public static StreamingDataSourceBuilder streamingDataSource() {
        return new StreamingDataSourceBuilderImpl();
    }

    public static PollingDataSourceBuilder pollingDataSource() {
        return new PollingDataSourceBuilderImpl();
    }

    public static DataSourceFactory externalUpdatesOnly() {
        return NullDataSourceFactory.INSTANCE;
    }

    public static HttpConfigurationBuilder httpConfiguration() {
        return new HttpConfigurationBuilderImpl();
    }

    public static HttpAuthentication httpBasicAuthentication(String username, String password) {
        return new HttpBasicAuthentication(username, password);
    }

    public static LoggingConfigurationBuilder logging() {
        return new LoggingConfigurationBuilderImpl();
    }

    public static FlagChangeListener flagValueMonitoringListener(LDClientInterface client, String flagKey, LDUser user, FlagValueChangeListener valueChangeListener) {
        return new FlagValueMonitoringListener(client, flagKey, user, valueChangeListener);
    }

    private static final class LoggingConfigurationBuilderImpl
    extends LoggingConfigurationBuilder {
        private LoggingConfigurationBuilderImpl() {
        }

        @Override
        public LoggingConfiguration createLoggingConfiguration() {
            return new LoggingConfigurationImpl(this.logDataSourceOutageAsErrorAfter);
        }
    }

    private static final class PersistentDataStoreBuilderImpl
    extends PersistentDataStoreBuilder
    implements DiagnosticDescription {
        public PersistentDataStoreBuilderImpl(PersistentDataStoreFactory persistentDataStoreFactory) {
            super(persistentDataStoreFactory);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            if (this.persistentDataStoreFactory instanceof DiagnosticDescription) {
                return ((DiagnosticDescription)((Object)this.persistentDataStoreFactory)).describeConfiguration(config);
            }
            return LDValue.of("custom");
        }

        @Override
        public DataStore createDataStore(ClientContext context, DataStoreUpdates dataStoreUpdates) {
            PersistentDataStore core = this.persistentDataStoreFactory.createPersistentDataStore(context);
            return new PersistentDataStoreWrapper(core, this.cacheTime, this.staleValuesPolicy, this.recordCacheStats, dataStoreUpdates, ClientContextImpl.get((ClientContext)context).sharedExecutor);
        }
    }

    private static final class HttpBasicAuthentication
    implements HttpAuthentication {
        private final String username;
        private final String password;

        HttpBasicAuthentication(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public String provideAuthorization(Iterable<HttpAuthentication.Challenge> challenges) {
            return Credentials.basic(this.username, this.password);
        }
    }

    private static final class HttpConfigurationBuilderImpl
    extends HttpConfigurationBuilder {
        private HttpConfigurationBuilderImpl() {
        }

        @Override
        public HttpConfiguration createHttpConfiguration() {
            return new HttpConfigurationImpl(this.connectTimeout, this.proxyHost == null ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort)), this.proxyAuth, this.socketTimeout, this.sslSocketFactory, this.trustManager, this.wrapperName == null ? null : (this.wrapperVersion == null ? this.wrapperName : this.wrapperName + "/" + this.wrapperVersion));
        }
    }

    private static final class EventProcessorBuilderImpl
    extends EventProcessorBuilder
    implements DiagnosticDescription {
        private EventProcessorBuilderImpl() {
        }

        @Override
        public EventProcessor createEventProcessor(ClientContext context) {
            if (context.isOffline()) {
                return new NullEventProcessor();
            }
            EventSender eventSender = (this.eventSenderFactory == null ? new DefaultEventSender.Factory() : this.eventSenderFactory).createEventSender(context.getSdkKey(), context.getHttpConfiguration());
            return new DefaultEventProcessor(new EventsConfiguration(this.allAttributesPrivate, this.capacity, eventSender, this.baseURI == null ? LDConfig.DEFAULT_EVENTS_URI : this.baseURI, this.flushInterval, this.inlineUsersInEvents, this.privateAttributes, this.userKeysCapacity, this.userKeysFlushInterval, this.diagnosticRecordingInterval), ClientContextImpl.get((ClientContext)context).sharedExecutor, context.getThreadPriority(), ClientContextImpl.get((ClientContext)context).diagnosticAccumulator, ClientContextImpl.get((ClientContext)context).diagnosticInitEvent);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.ALL_ATTRIBUTES_PRIVATE.name, this.allAttributesPrivate).put(DiagnosticEvent.ConfigProperty.CUSTOM_EVENTS_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_EVENTS_URI)).put(DiagnosticEvent.ConfigProperty.DIAGNOSTIC_RECORDING_INTERVAL_MILLIS.name, this.diagnosticRecordingInterval.toMillis()).put(DiagnosticEvent.ConfigProperty.EVENTS_CAPACITY.name, this.capacity).put(DiagnosticEvent.ConfigProperty.EVENTS_FLUSH_INTERVAL_MILLIS.name, this.flushInterval.toMillis()).put(DiagnosticEvent.ConfigProperty.INLINE_USERS_IN_EVENTS.name, this.inlineUsersInEvents).put(DiagnosticEvent.ConfigProperty.SAMPLING_INTERVAL.name, 0).put(DiagnosticEvent.ConfigProperty.USER_KEYS_CAPACITY.name, this.userKeysCapacity).put(DiagnosticEvent.ConfigProperty.USER_KEYS_FLUSH_INTERVAL_MILLIS.name, this.userKeysFlushInterval.toMillis()).build();
        }
    }

    private static final class PollingDataSourceBuilderImpl
    extends PollingDataSourceBuilder
    implements DiagnosticDescription {
        private PollingDataSourceBuilderImpl() {
        }

        @Override
        public DataSource createDataSource(ClientContext context, DataSourceUpdates dataSourceUpdates) {
            if (context.isOffline()) {
                return Components.externalUpdatesOnly().createDataSource(context, dataSourceUpdates);
            }
            LDClient.logger.info("Disabling streaming API");
            LDClient.logger.warn("You should only disable the streaming API if instructed to do so by LaunchDarkly support");
            DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(context.getSdkKey(), context.getHttpConfiguration(), this.baseURI == null ? LDConfig.DEFAULT_BASE_URI : this.baseURI, true);
            return new PollingProcessor(requestor, dataSourceUpdates, ClientContextImpl.get((ClientContext)context).sharedExecutor, this.pollInterval);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            if (config.offline) {
                return NullDataSourceFactory.INSTANCE.describeConfiguration(config);
            }
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, true).put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_BASE_URI)).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticEvent.ConfigProperty.POLLING_INTERVAL_MILLIS.name, this.pollInterval.toMillis()).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    private static final class StreamingDataSourceBuilderImpl
    extends StreamingDataSourceBuilder
    implements DiagnosticDescription {
        private StreamingDataSourceBuilderImpl() {
        }

        @Override
        public DataSource createDataSource(ClientContext context, DataSourceUpdates dataSourceUpdates) {
            URI streamUri;
            if (context.isOffline()) {
                return Components.externalUpdatesOnly().createDataSource(context, dataSourceUpdates);
            }
            LDClient.logger.info("Enabling streaming API");
            URI uRI = streamUri = this.baseURI == null ? LDConfig.DEFAULT_STREAM_URI : this.baseURI;
            URI pollUri = this.pollingBaseURI != null ? this.pollingBaseURI : (this.baseURI == null ? LDConfig.DEFAULT_BASE_URI : this.baseURI);
            DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(context.getSdkKey(), context.getHttpConfiguration(), pollUri, false);
            return new StreamProcessor(context.getSdkKey(), context.getHttpConfiguration(), requestor, dataSourceUpdates, null, context.getThreadPriority(), ClientContextImpl.get((ClientContext)context).diagnosticAccumulator, streamUri, this.initialReconnectDelay);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            if (config.offline) {
                return NullDataSourceFactory.INSTANCE.describeConfiguration(config);
            }
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, this.pollingBaseURI != null && !this.pollingBaseURI.equals(LDConfig.DEFAULT_BASE_URI) || this.pollingBaseURI == null && this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_STREAM_URI)).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_STREAM_URI)).put(DiagnosticEvent.ConfigProperty.RECONNECT_TIME_MILLIS.name, this.initialReconnectDelay.toMillis()).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    static final class NullDataSource
    implements DataSource {
        static final DataSource INSTANCE = new NullDataSource();

        NullDataSource() {
        }

        @Override
        public Future<Void> start() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static final class NullDataSourceFactory
    implements DataSourceFactory,
    DiagnosticDescription {
        static final NullDataSourceFactory INSTANCE = new NullDataSourceFactory();

        private NullDataSourceFactory() {
        }

        @Override
        public DataSource createDataSource(ClientContext context, DataSourceUpdates dataSourceUpdates) {
            if (context.isOffline()) {
                LDClient.logger.info("Starting LaunchDarkly client in offline mode");
            } else {
                LDClient.logger.info("LaunchDarkly client will not connect to Launchdarkly for feature flag data");
            }
            dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.VALID, null);
            return NullDataSource.INSTANCE;
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, false).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, config.dataStoreFactory != null && config.dataStoreFactory != Components.inMemoryDataStore()).build();
        }
    }

    static final class NullEventProcessor
    implements EventProcessor {
        static final NullEventProcessor INSTANCE = new NullEventProcessor();

        private NullEventProcessor() {
        }

        @Override
        public void sendEvent(Event e) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static final class InMemoryDataStoreFactory
    implements DataStoreFactory,
    DiagnosticDescription {
        static final DataStoreFactory INSTANCE = new InMemoryDataStoreFactory();

        private InMemoryDataStoreFactory() {
        }

        @Override
        public DataStore createDataStore(ClientContext context, DataStoreUpdates dataStoreUpdates) {
            return new InMemoryDataStore();
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            return LDValue.of("memory");
        }
    }
}

