/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelDependencies;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceUpdates;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.shaded.com.google.common.base.Joiner;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class DataSourceUpdatesImpl
implements DataSourceUpdates {
    private final DataStore store;
    private final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeEventNotifier;
    private final EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusNotifier;
    private final DataModelDependencies.DependencyTracker dependencyTracker = new DataModelDependencies.DependencyTracker();
    private final DataStoreStatusProvider dataStoreStatusProvider;
    private final OutageTracker outageTracker;
    private volatile DataSourceStatusProvider.Status currentStatus;
    private volatile boolean lastStoreUpdateFailed = false;

    DataSourceUpdatesImpl(DataStore store, DataStoreStatusProvider dataStoreStatusProvider, EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeEventNotifier, EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusNotifier, ScheduledExecutorService sharedExecutor, Duration outageLoggingTimeout) {
        this.store = store;
        this.flagChangeEventNotifier = flagChangeEventNotifier;
        this.dataSourceStatusNotifier = dataSourceStatusNotifier;
        this.dataStoreStatusProvider = dataStoreStatusProvider;
        this.outageTracker = new OutageTracker(sharedExecutor, outageLoggingTimeout);
        this.currentStatus = new DataSourceStatusProvider.Status(DataSourceStatusProvider.State.INITIALIZING, Instant.now(), null);
    }

    @Override
    public boolean init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldData = null;
        try {
            if (this.hasFlagChangeEventListeners()) {
                oldData = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
                for (DataStoreTypes.DataKind kind : DataModel.ALL_DATA_KINDS) {
                    DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items = this.store.getAll(kind);
                    oldData.put(kind, ImmutableMap.copyOf(items.getItems()));
                }
            }
            this.store.init(DataModelDependencies.sortAllCollections(allData));
            this.lastStoreUpdateFailed = false;
        }
        catch (RuntimeException e) {
            this.reportStoreFailure(e);
            return false;
        }
        this.updateDependencyTrackerFromFullDataSet(allData);
        if (oldData != null) {
            this.sendChangeEvents(this.computeChangedItemsForFullDataSet(oldData, this.fullDataSetToMap(allData)));
        }
        return true;
    }

    @Override
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        boolean successfullyUpdated;
        try {
            successfullyUpdated = this.store.upsert(kind, key, item);
            this.lastStoreUpdateFailed = false;
        }
        catch (RuntimeException e) {
            this.reportStoreFailure(e);
            return false;
        }
        if (successfullyUpdated) {
            this.dependencyTracker.updateDependenciesFrom(kind, key, item);
            if (this.hasFlagChangeEventListeners()) {
                HashSet<DataModelDependencies.KindAndKey> affectedItems = new HashSet<DataModelDependencies.KindAndKey>();
                this.dependencyTracker.addAffectedItems(affectedItems, new DataModelDependencies.KindAndKey(kind, key));
                this.sendChangeEvents(affectedItems);
            }
        }
        return true;
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
        if (newState == null) {
            return;
        }
        DataSourceStatusProvider.Status statusToBroadcast = null;
        DataSourceUpdatesImpl dataSourceUpdatesImpl = this;
        synchronized (dataSourceUpdatesImpl) {
            DataSourceStatusProvider.Status oldStatus = this.currentStatus;
            if (newState == DataSourceStatusProvider.State.INTERRUPTED && oldStatus.getState() == DataSourceStatusProvider.State.INITIALIZING) {
                newState = DataSourceStatusProvider.State.INITIALIZING;
            }
            if (newState != oldStatus.getState() || newError != null) {
                statusToBroadcast = this.currentStatus = new DataSourceStatusProvider.Status(newState, newState == this.currentStatus.getState() ? this.currentStatus.getStateSince() : Instant.now(), newError == null ? this.currentStatus.getLastError() : newError);
            }
            this.outageTracker.trackDataSourceState(newState, newError);
        }
        if (statusToBroadcast != null) {
            this.dataSourceStatusNotifier.broadcast(statusToBroadcast);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceStatusProvider.Status getLastStatus() {
        DataSourceUpdatesImpl dataSourceUpdatesImpl = this;
        synchronized (dataSourceUpdatesImpl) {
            return this.currentStatus;
        }
    }

    private boolean hasFlagChangeEventListeners() {
        return this.flagChangeEventNotifier.hasListeners();
    }

    private void sendChangeEvents(Iterable<DataModelDependencies.KindAndKey> affectedItems) {
        for (DataModelDependencies.KindAndKey item : affectedItems) {
            if (item.kind != DataModel.FEATURES) continue;
            this.flagChangeEventNotifier.broadcast(new FlagChangeEvent(item.key));
        }
    }

    private void updateDependencyTrackerFromFullDataSet(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        this.dependencyTracker.reset();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e0 : allData.getData()) {
            DataStoreTypes.DataKind kind = e0.getKey();
            for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e1 : e0.getValue().getItems()) {
                String key = e1.getKey();
                this.dependencyTracker.updateDependenciesFrom(kind, key, e1.getValue());
            }
        }
    }

    private Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> fullDataSetToMap(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> ret = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e : allData.getData()) {
            ret.put(e.getKey(), ImmutableMap.copyOf(e.getValue().getItems()));
        }
        return ret;
    }

    private Set<DataModelDependencies.KindAndKey> computeChangedItemsForFullDataSet(Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldDataMap, Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> newDataMap) {
        HashSet<DataModelDependencies.KindAndKey> affectedItems = new HashSet<DataModelDependencies.KindAndKey>();
        for (DataStoreTypes.DataKind kind : DataModel.ALL_DATA_KINDS) {
            Map<String, DataStoreTypes.ItemDescriptor> oldItems = oldDataMap.get(kind);
            Map<String, DataStoreTypes.ItemDescriptor> newItems = newDataMap.get(kind);
            if (oldItems == null) {
                oldItems = Collections.emptyMap();
            }
            if (newItems == null) {
                newItems = Collections.emptyMap();
            }
            ImmutableSet<String> allKeys = ImmutableSet.copyOf(Iterables.concat(oldItems.keySet(), newItems.keySet()));
            for (String key : allKeys) {
                DataStoreTypes.ItemDescriptor oldItem = oldItems.get(key);
                DataStoreTypes.ItemDescriptor newItem = newItems.get(key);
                if (oldItem == null && newItem == null || oldItem != null && newItem != null && oldItem.getVersion() >= newItem.getVersion()) continue;
                this.dependencyTracker.addAffectedItems(affectedItems, new DataModelDependencies.KindAndKey(kind, key));
            }
        }
        return affectedItems;
    }

    private void reportStoreFailure(RuntimeException e) {
        if (!this.lastStoreUpdateFailed) {
            LDClient.logger.warn("Unexpected data store error when trying to store an update received from the data source: {}", (Object)e.toString());
            this.lastStoreUpdateFailed = true;
        }
        LDClient.logger.debug(e.toString(), (Throwable)e);
        this.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromException(DataSourceStatusProvider.ErrorKind.STORE_ERROR, e));
    }

    private static final class OutageTracker {
        private final boolean enabled;
        private final ScheduledExecutorService sharedExecutor;
        private final Duration loggingTimeout;
        private final HashMap<DataSourceStatusProvider.ErrorInfo, Integer> errorCounts = new HashMap();
        private volatile boolean inOutage;
        private volatile ScheduledFuture<?> timeoutFuture;

        OutageTracker(ScheduledExecutorService sharedExecutor, Duration loggingTimeout) {
            this.sharedExecutor = sharedExecutor;
            this.loggingTimeout = loggingTimeout;
            this.enabled = loggingTimeout != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trackDataSourceState(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
            if (!this.enabled) {
                return;
            }
            OutageTracker outageTracker = this;
            synchronized (outageTracker) {
                if (newState == DataSourceStatusProvider.State.INTERRUPTED || newError != null || newState == DataSourceStatusProvider.State.INITIALIZING && this.inOutage) {
                    if (this.inOutage) {
                        this.recordError(newError);
                    } else {
                        this.inOutage = true;
                        this.errorCounts.clear();
                        this.recordError(newError);
                        this.timeoutFuture = this.sharedExecutor.schedule(this::onTimeout, this.loggingTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    }
                } else {
                    if (this.timeoutFuture != null) {
                        this.timeoutFuture.cancel(false);
                        this.timeoutFuture = null;
                    }
                    this.inOutage = false;
                }
            }
        }

        private void recordError(DataSourceStatusProvider.ErrorInfo newError) {
            DataSourceStatusProvider.ErrorInfo basicErrorInfo = new DataSourceStatusProvider.ErrorInfo(newError.getKind(), newError.getStatusCode(), null, null);
            LDClient.logger.warn("recordError(" + basicErrorInfo + ")");
            this.errorCounts.compute(basicErrorInfo, (key, oldValue) -> oldValue == null ? 1 : oldValue + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onTimeout() {
            String errorsDesc;
            OutageTracker outageTracker = this;
            synchronized (outageTracker) {
                if (this.timeoutFuture == null || !this.inOutage) {
                    return;
                }
                this.timeoutFuture = null;
                errorsDesc = Joiner.on(", ").join(Iterables.transform(this.errorCounts.entrySet(), OutageTracker::describeErrorCount));
            }
            LDClient.logger.error("LaunchDarkly data source outage - updates have been unavailable for at least {} with the following errors: {}", (Object)Util.describeDuration(this.loggingTimeout), (Object)errorsDesc);
        }

        private static String describeErrorCount(Map.Entry<DataSourceStatusProvider.ErrorInfo, Integer> entry) {
            return entry.getKey() + " (" + entry.getValue() + (entry.getValue() == 1 ? " time" : " times") + ")";
        }
    }
}

