/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.FeatureRequestor;
import com.launchdarkly.sdk.server.HttpErrorException;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.sdk.server.interfaces.SerializationException;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.Maps;
import com.launchdarkly.shaded.com.google.common.io.Files;
import com.launchdarkly.shaded.okhttp3.Cache;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultFeatureRequestor
implements FeatureRequestor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFeatureRequestor.class);
    private static final String GET_LATEST_FLAGS_PATH = "/sdk/latest-flags";
    private static final String GET_LATEST_SEGMENTS_PATH = "/sdk/latest-segments";
    private static final String GET_LATEST_ALL_PATH = "/sdk/latest-all";
    private static final long MAX_HTTP_CACHE_SIZE_BYTES = 0xA00000L;
    @VisibleForTesting
    final URI baseUri;
    private final OkHttpClient httpClient;
    private final Headers headers;
    private final boolean useCache;

    DefaultFeatureRequestor(String sdkKey, HttpConfiguration httpConfig, URI baseUri, boolean useCache) {
        this.baseUri = baseUri;
        this.useCache = useCache;
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
        Util.configureHttpClientBuilder(httpConfig, httpBuilder);
        this.headers = Util.getHeadersBuilderFor(sdkKey, httpConfig).build();
        if (useCache) {
            File cacheDir = Files.createTempDir();
            Cache cache = new Cache(cacheDir, 0xA00000L);
            httpBuilder.cache(cache);
        }
        this.httpClient = httpBuilder.build();
    }

    @Override
    public void close() {
        Util.shutdownHttpClient(this.httpClient);
    }

    @Override
    public DataModel.FeatureFlag getFlag(String featureKey) throws IOException, HttpErrorException, SerializationException {
        String body = this.get("/sdk/latest-flags/" + featureKey);
        return JsonHelpers.deserialize(body, DataModel.FeatureFlag.class);
    }

    @Override
    public DataModel.Segment getSegment(String segmentKey) throws IOException, HttpErrorException, SerializationException {
        String body = this.get("/sdk/latest-segments/" + segmentKey);
        return JsonHelpers.deserialize(body, DataModel.Segment.class);
    }

    @Override
    public FeatureRequestor.AllData getAllData() throws IOException, HttpErrorException, SerializationException {
        String body = this.get(GET_LATEST_ALL_PATH);
        return JsonHelpers.deserialize(body, FeatureRequestor.AllData.class);
    }

    static DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> toFullDataSet(FeatureRequestor.AllData allData) {
        return new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(ImmutableMap.of(DataModel.FEATURES, DefaultFeatureRequestor.toKeyedItems(allData.flags), DataModel.SEGMENTS, DefaultFeatureRequestor.toKeyedItems(allData.segments)).entrySet());
    }

    static <T extends DataModel.VersionedData> DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> toKeyedItems(Map<String, T> itemsMap) {
        if (itemsMap == null) {
            return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(null);
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(ImmutableList.copyOf(Maps.transformValues(itemsMap, item -> new DataStoreTypes.ItemDescriptor(item.getVersion(), item)).entrySet()));
    }

    private String get(String path) throws IOException, HttpErrorException {
        Request request = new Request.Builder().url(this.baseUri.resolve(path).toURL()).headers(this.headers).get().build();
        logger.debug("Making request: " + request);
        try (Response response = this.httpClient.newCall(request).execute();){
            String body = response.body().string();
            if (!response.isSuccessful()) {
                throw new HttpErrorException(response.code());
            }
            logger.debug("Get flag(s) response: " + response.toString() + " with body: " + body);
            logger.debug("Network response: " + response.networkResponse());
            if (this.useCache) {
                logger.debug("Cache hit count: " + this.httpClient.cache().hitCount() + " Cache network Count: " + this.httpClient.cache().networkCount());
                logger.debug("Cache response: " + response.cacheResponse());
            }
            String string = body;
            return string;
        }
    }
}

