/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;

final class EventBroadcasterImpl<ListenerT, EventT> {
    private final CopyOnWriteArrayList<ListenerT> listeners = new CopyOnWriteArrayList();
    private final BiConsumer<ListenerT, EventT> broadcastAction;
    private final ExecutorService executor;

    EventBroadcasterImpl(BiConsumer<ListenerT, EventT> broadcastAction, ExecutorService executor) {
        this.broadcastAction = broadcastAction;
        this.executor = executor;
    }

    static EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> forFlagChangeEvents(ExecutorService executor) {
        return new EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent>(FlagChangeListener::onFlagChange, executor);
    }

    static EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> forDataSourceStatus(ExecutorService executor) {
        return new EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status>(DataSourceStatusProvider.StatusListener::dataSourceStatusChanged, executor);
    }

    static EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> forDataStoreStatus(ExecutorService executor) {
        return new EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status>(DataStoreStatusProvider.StatusListener::dataStoreStatusChanged, executor);
    }

    void register(ListenerT listener) {
        this.listeners.add(listener);
    }

    void unregister(ListenerT listener) {
        this.listeners.remove(listener);
    }

    boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    void broadcast(EventT event) {
        if (this.executor == null) {
            return;
        }
        for (ListenerT l : this.listeners) {
            this.executor.execute(() -> {
                try {
                    this.broadcastAction.accept(l, event);
                }
                catch (Exception e) {
                    LDClient.logger.warn("Unexpected error from listener ({0}): {1}", l.getClass(), (Object)e.toString());
                    LDClient.logger.debug(e.toString(), (Throwable)e);
                }
            });
        }
    }
}

