/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.LDClientInterface;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagValueChangeListener;
import java.util.concurrent.atomic.AtomicReference;

final class FlagValueMonitoringListener
implements FlagChangeListener {
    private final LDClientInterface client;
    private final AtomicReference<LDValue> currentValue = new AtomicReference<LDValue>(LDValue.ofNull());
    private final String flagKey;
    private final LDUser user;
    private final FlagValueChangeListener valueChangeListener;

    public FlagValueMonitoringListener(LDClientInterface client, String flagKey, LDUser user, FlagValueChangeListener valueChangeListener) {
        this.client = client;
        this.flagKey = flagKey;
        this.user = user;
        this.valueChangeListener = valueChangeListener;
        this.currentValue.set(client.jsonValueVariation(flagKey, user, LDValue.ofNull()));
    }

    @Override
    public void onFlagChange(FlagChangeEvent event) {
        LDValue previousValue;
        LDValue newValue;
        if (event.getKey().equals(this.flagKey) && !(newValue = this.client.jsonValueVariation(this.flagKey, this.user, LDValue.ofNull())).equals(previousValue = this.currentValue.getAndSet(newValue))) {
            this.valueChangeListener.onFlagValueChange(new FlagValueChangeEvent(this.flagKey, previousValue, newValue));
        }
    }
}

