/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataSourceStatusProviderImpl;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.DiagnosticAccumulator;
import com.launchdarkly.sdk.server.DiagnosticId;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.EventFactory;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.LDClientInterface;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSource;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceUpdates;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreFactory;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.sdk.server.interfaces.EventProcessor;
import com.launchdarkly.sdk.server.interfaces.EventProcessorFactory;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.shaded.com.google.common.base.Preconditions;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.org.apache.commons.codec.binary.Hex;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDClient
implements LDClientInterface {
    static final Logger logger = LoggerFactory.getLogger(LDClient.class);
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    static final String CLIENT_VERSION = LDClient.getClientVersion();
    private final String sdkKey;
    private final boolean offline;
    private final Evaluator evaluator;
    final EventProcessor eventProcessor;
    final DataSource dataSource;
    final DataStore dataStore;
    private final DataSourceUpdates dataSourceUpdates;
    private final DataStoreStatusProviderImpl dataStoreStatusProvider;
    private final DataSourceStatusProviderImpl dataSourceStatusProvider;
    private final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeEventNotifier;
    private final ScheduledExecutorService sharedExecutor;

    public LDClient(String sdkKey) {
        this(sdkKey, LDConfig.DEFAULT);
    }

    private static final DataModel.FeatureFlag getFlag(DataStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.FEATURES, key);
        return item == null ? null : (DataModel.FeatureFlag)item.getItem();
    }

    private static final DataModel.Segment getSegment(DataStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.SEGMENTS, key);
        return item == null ? null : (DataModel.Segment)item.getItem();
    }

    public LDClient(String sdkKey, LDConfig config) {
        EventProcessorFactory epFactory;
        Preconditions.checkNotNull(config, "config must not be null");
        this.sdkKey = Preconditions.checkNotNull(sdkKey, "sdkKey must not be null");
        this.offline = config.offline;
        this.sharedExecutor = this.createSharedExecutor(config);
        EventProcessorFactory eventProcessorFactory = epFactory = config.eventProcessorFactory == null ? Components.sendEvents() : config.eventProcessorFactory;
        if (config.httpConfig.getProxy() != null) {
            if (config.httpConfig.getProxyAuthentication() != null) {
                logger.info("Using proxy: {} with authentication.", (Object)config.httpConfig.getProxy());
            } else {
                logger.info("Using proxy: {} without authentication.", (Object)config.httpConfig.getProxy());
            }
        }
        boolean useDiagnostics = !config.diagnosticOptOut && epFactory instanceof EventProcessorBuilder;
        ClientContextImpl context = new ClientContextImpl(sdkKey, config, this.sharedExecutor, useDiagnostics ? new DiagnosticAccumulator(new DiagnosticId(sdkKey)) : null);
        this.eventProcessor = epFactory.createEventProcessor(context);
        DataStoreFactory factory = config.dataStoreFactory == null ? Components.inMemoryDataStore() : config.dataStoreFactory;
        EventBroadcasterImpl<DataStoreStatusProvider.StatusListener, DataStoreStatusProvider.Status> dataStoreStatusNotifier = EventBroadcasterImpl.forDataStoreStatus(this.sharedExecutor);
        DataStoreUpdatesImpl dataStoreUpdates = new DataStoreUpdatesImpl(dataStoreStatusNotifier);
        this.dataStore = factory.createDataStore(context, dataStoreUpdates);
        this.evaluator = new Evaluator(new Evaluator.Getters(){

            @Override
            public DataModel.FeatureFlag getFlag(String key) {
                return LDClient.getFlag(LDClient.this.dataStore, key);
            }

            @Override
            public DataModel.Segment getSegment(String key) {
                return LDClient.getSegment(LDClient.this.dataStore, key);
            }
        });
        this.flagChangeEventNotifier = EventBroadcasterImpl.forFlagChangeEvents(this.sharedExecutor);
        this.dataStoreStatusProvider = new DataStoreStatusProviderImpl(this.dataStore, dataStoreUpdates);
        DataSourceFactory dataSourceFactory = config.dataSourceFactory == null ? Components.streamingDataSource() : config.dataSourceFactory;
        EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusNotifier = EventBroadcasterImpl.forDataSourceStatus(this.sharedExecutor);
        DataSourceUpdatesImpl dataSourceUpdates = new DataSourceUpdatesImpl(this.dataStore, this.dataStoreStatusProvider, this.flagChangeEventNotifier, dataSourceStatusNotifier, this.sharedExecutor, config.loggingConfig.getLogDataSourceOutageAsErrorAfter());
        this.dataSourceUpdates = dataSourceUpdates;
        this.dataSource = dataSourceFactory.createDataSource(context, dataSourceUpdates);
        this.dataSourceStatusProvider = new DataSourceStatusProviderImpl(dataSourceStatusNotifier, dataSourceUpdates::getLastStatus);
        Future<Void> startFuture = this.dataSource.start();
        if (!config.startWait.isZero() && !config.startWait.isNegative()) {
            if (!(this.dataSource instanceof Components.NullDataSource)) {
                logger.info("Waiting up to " + config.startWait.toMillis() + " milliseconds for LaunchDarkly client to start...");
            }
            try {
                startFuture.get(config.startWait.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                logger.error("Timeout encountered waiting for LaunchDarkly client initialization");
            }
            catch (Exception e) {
                logger.error("Exception encountered waiting for LaunchDarkly client initialization: {}", (Object)e.toString());
                logger.debug(e.toString(), (Throwable)e);
            }
            if (!this.dataSource.isInitialized()) {
                logger.warn("LaunchDarkly client was not successfully initialized");
            }
        }
    }

    @Override
    public boolean initialized() {
        return this.dataSource.isInitialized();
    }

    @Override
    public void track(String eventName, LDUser user) {
        this.trackData(eventName, user, LDValue.ofNull());
    }

    @Override
    public void trackData(String eventName, LDUser user, LDValue data) {
        if (user == null || user.getKey() == null) {
            logger.warn("Track called with null user or null user key!");
        } else {
            this.eventProcessor.sendEvent(EventFactory.DEFAULT.newCustomEvent(eventName, user, data, null));
        }
    }

    @Override
    public void trackMetric(String eventName, LDUser user, LDValue data, double metricValue) {
        if (user == null || user.getKey() == null) {
            logger.warn("Track called with null user or null user key!");
        } else {
            this.eventProcessor.sendEvent(EventFactory.DEFAULT.newCustomEvent(eventName, user, data, metricValue));
        }
    }

    @Override
    public void identify(LDUser user) {
        if (user == null || user.getKey() == null) {
            logger.warn("Identify called with null user or null user key!");
        } else {
            this.eventProcessor.sendEvent(EventFactory.DEFAULT.newIdentifyEvent(user));
        }
    }

    private void sendFlagRequestEvent(Event.FeatureRequest event) {
        this.eventProcessor.sendEvent(event);
    }

    @Override
    public FeatureFlagsState allFlagsState(LDUser user, FlagsStateOption ... options) {
        FeatureFlagsState.Builder builder = new FeatureFlagsState.Builder(options);
        if (this.isOffline()) {
            logger.debug("allFlagsState() was called when client is in offline mode.");
        }
        if (!this.initialized()) {
            if (this.dataStore.isInitialized()) {
                logger.warn("allFlagsState() was called before client initialized; using last known values from data store");
            } else {
                logger.warn("allFlagsState() was called before client initialized; data store unavailable, returning no data");
                return builder.valid(false).build();
            }
        }
        if (user == null || user.getKey() == null) {
            logger.warn("allFlagsState() was called with null user or null user key! returning no data");
            return builder.valid(false).build();
        }
        boolean clientSideOnly = FlagsStateOption.hasOption(options, FlagsStateOption.CLIENT_SIDE_ONLY);
        DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> flags = this.dataStore.getAll(DataModel.FEATURES);
        for (Map.Entry<String, DataStoreTypes.ItemDescriptor> entry : flags.getItems()) {
            if (entry.getValue().getItem() == null) continue;
            DataModel.FeatureFlag flag = (DataModel.FeatureFlag)entry.getValue().getItem();
            if (clientSideOnly && !flag.isClientSide()) continue;
            try {
                Evaluator.EvalResult result = this.evaluator.evaluate(flag, user, EventFactory.DEFAULT);
                builder.addFlag(flag, result);
            }
            catch (Exception e) {
                logger.error("Exception caught for feature flag \"{}\" when evaluating all flags: {}", (Object)entry.getKey(), (Object)e.toString());
                logger.debug(e.toString(), (Throwable)e);
                builder.addFlag(flag, new Evaluator.EvalResult(LDValue.ofNull(), -1, EvaluationReason.exception(e)));
            }
        }
        return builder.build();
    }

    @Override
    public boolean boolVariation(String featureKey, LDUser user, boolean defaultValue) {
        return this.evaluate(featureKey, user, LDValue.of(defaultValue), true).booleanValue();
    }

    @Override
    public Integer intVariation(String featureKey, LDUser user, int defaultValue) {
        return this.evaluate(featureKey, user, LDValue.of(defaultValue), true).intValue();
    }

    @Override
    public Double doubleVariation(String featureKey, LDUser user, Double defaultValue) {
        return this.evaluate(featureKey, user, LDValue.of(defaultValue), true).doubleValue();
    }

    @Override
    public String stringVariation(String featureKey, LDUser user, String defaultValue) {
        return this.evaluate(featureKey, user, LDValue.of(defaultValue), true).stringValue();
    }

    @Override
    public LDValue jsonValueVariation(String featureKey, LDUser user, LDValue defaultValue) {
        return this.evaluate(featureKey, user, LDValue.normalize(defaultValue), false);
    }

    @Override
    public EvaluationDetail<Boolean> boolVariationDetail(String featureKey, LDUser user, boolean defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.of(defaultValue), true, EventFactory.DEFAULT_WITH_REASONS);
        return EvaluationDetail.fromValue(result.getValue().booleanValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public EvaluationDetail<Integer> intVariationDetail(String featureKey, LDUser user, int defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.of(defaultValue), true, EventFactory.DEFAULT_WITH_REASONS);
        return EvaluationDetail.fromValue(result.getValue().intValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public EvaluationDetail<Double> doubleVariationDetail(String featureKey, LDUser user, double defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.of(defaultValue), true, EventFactory.DEFAULT_WITH_REASONS);
        return EvaluationDetail.fromValue(result.getValue().doubleValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public EvaluationDetail<String> stringVariationDetail(String featureKey, LDUser user, String defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.of(defaultValue), true, EventFactory.DEFAULT_WITH_REASONS);
        return EvaluationDetail.fromValue(result.getValue().stringValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public EvaluationDetail<LDValue> jsonValueVariationDetail(String featureKey, LDUser user, LDValue defaultValue) {
        Evaluator.EvalResult result = this.evaluateInternal(featureKey, user, LDValue.normalize(defaultValue), false, EventFactory.DEFAULT_WITH_REASONS);
        return EvaluationDetail.fromValue(result.getValue(), result.getVariationIndex(), result.getReason());
    }

    @Override
    public boolean isFlagKnown(String featureKey) {
        if (!this.initialized()) {
            if (this.dataStore.isInitialized()) {
                logger.warn("isFlagKnown called before client initialized for feature flag \"{}\"; using last known values from data store", (Object)featureKey);
            } else {
                logger.warn("isFlagKnown called before client initialized for feature flag \"{}\"; data store unavailable, returning false", (Object)featureKey);
                return false;
            }
        }
        try {
            if (LDClient.getFlag(this.dataStore, featureKey) != null) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Encountered exception while calling isFlagKnown for feature flag \"{}\": {}", (Object)e.toString());
            logger.debug(e.toString(), (Throwable)e);
        }
        return false;
    }

    private LDValue evaluate(String featureKey, LDUser user, LDValue defaultValue, boolean checkType) {
        return this.evaluateInternal(featureKey, user, defaultValue, checkType, EventFactory.DEFAULT).getValue();
    }

    private Evaluator.EvalResult errorResult(EvaluationReason.ErrorKind errorKind, LDValue defaultValue) {
        return new Evaluator.EvalResult(defaultValue, -1, EvaluationReason.error(errorKind));
    }

    private Evaluator.EvalResult evaluateInternal(String featureKey, LDUser user, LDValue defaultValue, boolean checkType, EventFactory eventFactory) {
        if (!this.initialized()) {
            if (this.dataStore.isInitialized()) {
                logger.warn("Evaluation called before client initialized for feature flag \"{}\"; using last known values from data store", (Object)featureKey);
            } else {
                logger.warn("Evaluation called before client initialized for feature flag \"{}\"; data store unavailable, returning default value", (Object)featureKey);
                this.sendFlagRequestEvent(eventFactory.newUnknownFeatureRequestEvent(featureKey, user, defaultValue, EvaluationReason.ErrorKind.CLIENT_NOT_READY));
                return this.errorResult(EvaluationReason.ErrorKind.CLIENT_NOT_READY, defaultValue);
            }
        }
        DataModel.FeatureFlag featureFlag = null;
        try {
            featureFlag = LDClient.getFlag(this.dataStore, featureKey);
            if (featureFlag == null) {
                logger.info("Unknown feature flag \"{}\"; returning default value", (Object)featureKey);
                this.sendFlagRequestEvent(eventFactory.newUnknownFeatureRequestEvent(featureKey, user, defaultValue, EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
                return this.errorResult(EvaluationReason.ErrorKind.FLAG_NOT_FOUND, defaultValue);
            }
            if (user == null || user.getKey() == null) {
                logger.warn("Null user or null user key when evaluating flag \"{}\"; returning default value", (Object)featureKey);
                this.sendFlagRequestEvent(eventFactory.newDefaultFeatureRequestEvent(featureFlag, user, defaultValue, EvaluationReason.ErrorKind.USER_NOT_SPECIFIED));
                return this.errorResult(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED, defaultValue);
            }
            if (user.getKey().isEmpty()) {
                logger.warn("User key is blank. Flag evaluation will proceed, but the user will not be stored in LaunchDarkly");
            }
            Evaluator.EvalResult evalResult = this.evaluator.evaluate(featureFlag, user, eventFactory);
            for (Event.FeatureRequest event : evalResult.getPrerequisiteEvents()) {
                this.eventProcessor.sendEvent(event);
            }
            if (evalResult.isDefault()) {
                evalResult.setValue(defaultValue);
            } else {
                LDValue value = evalResult.getValue();
                if (checkType && !value.isNull() && !defaultValue.isNull() && defaultValue.getType() != value.getType()) {
                    logger.error("Feature flag evaluation expected result as {}, but got {}", (Object)defaultValue.getType(), (Object)value.getType());
                    this.sendFlagRequestEvent(eventFactory.newUnknownFeatureRequestEvent(featureKey, user, defaultValue, EvaluationReason.ErrorKind.WRONG_TYPE));
                    return this.errorResult(EvaluationReason.ErrorKind.WRONG_TYPE, defaultValue);
                }
            }
            this.sendFlagRequestEvent(eventFactory.newFeatureRequestEvent(featureFlag, user, evalResult, defaultValue));
            return evalResult;
        }
        catch (Exception e) {
            logger.error("Encountered exception while evaluating feature flag \"{}\": {}", (Object)featureKey, (Object)e.toString());
            logger.debug(e.toString(), (Throwable)e);
            if (featureFlag == null) {
                this.sendFlagRequestEvent(eventFactory.newUnknownFeatureRequestEvent(featureKey, user, defaultValue, EvaluationReason.ErrorKind.EXCEPTION));
            } else {
                this.sendFlagRequestEvent(eventFactory.newDefaultFeatureRequestEvent(featureFlag, user, defaultValue, EvaluationReason.ErrorKind.EXCEPTION));
            }
            return new Evaluator.EvalResult(defaultValue, -1, EvaluationReason.exception(e));
        }
    }

    @Override
    public void registerFlagChangeListener(FlagChangeListener listener) {
        this.flagChangeEventNotifier.register(listener);
    }

    @Override
    public void unregisterFlagChangeListener(FlagChangeListener listener) {
        this.flagChangeEventNotifier.unregister(listener);
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    @Override
    public DataSourceStatusProvider getDataSourceStatusProvider() {
        return this.dataSourceStatusProvider;
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly Client");
        this.dataStore.close();
        this.eventProcessor.close();
        this.dataSource.close();
        this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.OFF, null);
        this.sharedExecutor.shutdownNow();
    }

    @Override
    public void flush() {
        this.eventProcessor.flush();
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public String secureModeHash(LDUser user) {
        if (user == null || user.getKey() == null) {
            return null;
        }
        try {
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(new SecretKeySpec(this.sdkKey.getBytes(), HMAC_ALGORITHM));
            return Hex.encodeHexString(mac.doFinal(user.getKey().getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            logger.error("Could not generate secure mode hash: {}", (Object)e.toString());
            logger.debug(e.toString(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String version() {
        return CLIENT_VERSION;
    }

    private ScheduledExecutorService createSharedExecutor(LDConfig config) {
        ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-tasks-%d").setPriority(config.threadPriority).build();
        return Executors.newSingleThreadScheduledExecutor(threadFactory2);
    }

    private static String getClientVersion() {
        Class<LDConfig> clazz = LDConfig.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return "Unknown";
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        Manifest manifest = null;
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Implementation-Version");
            return value;
        }
        catch (IOException e) {
            logger.warn("Unable to determine LaunchDarkly client library version: {}", (Object)e.toString());
            logger.debug(e.toString(), (Throwable)e);
            return "Unknown";
        }
    }
}

