/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import com.launchdarkly.shaded.okhttp3.Route;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

class Util {
    Util() {
    }

    static Headers.Builder getHeadersBuilderFor(String sdkKey, HttpConfiguration config) {
        Headers.Builder builder = new Headers.Builder().add("Authorization", sdkKey).add("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
        if (config.getWrapperIdentifier() != null) {
            builder.add("X-LaunchDarkly-Wrapper", config.getWrapperIdentifier());
        }
        return builder;
    }

    static void configureHttpClientBuilder(HttpConfiguration config, OkHttpClient.Builder builder) {
        builder.connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(config.getConnectTimeout()).readTimeout(config.getSocketTimeout()).writeTimeout(config.getSocketTimeout()).retryOnConnectionFailure(false);
        if (config.getSslSocketFactory() != null) {
            builder.sslSocketFactory(config.getSslSocketFactory(), config.getTrustManager());
        }
        if (config.getProxy() != null) {
            builder.proxy(config.getProxy());
            if (config.getProxyAuthentication() != null) {
                builder.proxyAuthenticator(Util.okhttpAuthenticatorFromHttpAuthStrategy(config.getProxyAuthentication(), "Proxy-Authentication", "Proxy-Authorization"));
            }
        }
    }

    static final Authenticator okhttpAuthenticatorFromHttpAuthStrategy(final HttpAuthentication strategy, String challengeHeaderName, final String responseHeaderName) {
        return new Authenticator(){

            @Override
            public Request authenticate(Route route, Response response) throws IOException {
                if (response.request().header(responseHeaderName) != null) {
                    return null;
                }
                Iterable<HttpAuthentication.Challenge> challenges = Iterables.transform(response.challenges(), c -> new HttpAuthentication.Challenge(c.scheme(), c.realm()));
                String credential = strategy.provideAuthorization(challenges);
                return response.request().newBuilder().header(responseHeaderName, credential).build();
            }
        };
    }

    static void shutdownHttpClient(OkHttpClient client) {
        if (client.dispatcher() != null) {
            client.dispatcher().cancelAll();
            if (client.dispatcher().executorService() != null) {
                client.dispatcher().executorService().shutdown();
            }
        }
        if (client.connectionPool() != null) {
            client.connectionPool().evictAll();
        }
        if (client.cache() != null) {
            try {
                client.cache().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isHttpErrorRecoverable(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 400: 
                case 408: 
                case 429: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    static boolean checkIfErrorIsRecoverableAndLog(Logger logger, String errorDesc, String errorContext, int statusCode, String recoverableMessage) {
        if (statusCode > 0 && !Util.isHttpErrorRecoverable(statusCode)) {
            logger.error("Error {} (giving up permanently): {}", (Object)errorContext, (Object)errorDesc);
            return false;
        }
        logger.warn("Error {} ({}): {}", new Object[]{errorContext, recoverableMessage, errorDesc});
        return true;
    }

    static String httpErrorDescription(int statusCode) {
        return "HTTP error " + statusCode + (statusCode == 401 || statusCode == 403 ? " (invalid SDK key)" : "");
    }

    static String describeDuration(Duration d) {
        if (d.toMillis() % 1000L == 0L) {
            if (d.toMillis() % 60000L == 0L) {
                return d.toMinutes() + (d.toMinutes() == 1L ? " minute" : " minutes");
            }
            long sec = d.toMillis() / 1000L;
            return sec + (sec == 1L ? " second" : " seconds");
        }
        return d.toMillis() + " milliseconds";
    }
}

