/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.google.common.util.concurrent;

import com.launchdarkly.shaded.com.google.common.annotations.GwtCompatible;
import com.launchdarkly.shaded.com.google.common.base.Optional;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableCollection;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.Lists;
import com.launchdarkly.shaded.com.google.common.util.concurrent.AggregateFuture;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.launchdarkly.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    private List<Optional<V>> values;

    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        this.values = futures.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            this.values.add(null);
        }
    }

    @Override
    final void collectOneValue(int index, @Nullable V returnValue) {
        List<Optional<V>> localValues = this.values;
        if (localValues != null) {
            localValues.set(index, Optional.fromNullable(returnValue));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<Optional<V>> localValues = this.values;
        if (localValues != null) {
            this.set(this.combine(localValues));
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        this.values = null;
    }

    abstract C combine(List<Optional<V>> var1);

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed);
            this.init();
        }

        @Override
        public List<V> combine(List<Optional<V>> values2) {
            ArrayList<Object> result = Lists.newArrayListWithCapacity(values2.size());
            for (Optional<V> element : values2) {
                result.add(element != null ? (Object)element.orNull() : null);
            }
            return Collections.unmodifiableList(result);
        }
    }
}

